using UnityEngine;
using UnityEditor;
using UnityEditor.AssetImporters;
using System.IO;

public class AddCollidersPostProcessor : AssetPostprocessor
{
    static void OnPostprocessAllAssets(string[] importedAssets, string[] deletedAssets, string[] movedAssets, string[] movedFromAssetPaths)
    {
        foreach (string assetPath in importedAssets) {
            if (assetPath.EndsWith(".gltf") || assetPath.EndsWith(".glb")) {
                // GameObject[h
                GameObject importedObject = AssetDatabase.LoadAssetAtPath<GameObject>(assetPath);
                if (importedObject != null) {
                    Debug.Log($"Loaded GameObject: {importedObject.name} from path: {assetPath}");
                    // CX^X쐬ăRC_[ǉ
                    GameObject instance = (GameObject)PrefabUtility.InstantiatePrefab(importedObject);
                    if (instance != null) {
                        AddColliderAndRigidbody(instance);
                    }
                    else {
                        Debug.LogError($"Failed to instantiate prefab for: {importedObject.name}");
                    }
                }
                else {
                    Debug.LogError($"Failed to load GameObject from path: {assetPath}");
                }
            }
        }
    }

    static void AddColliderAndRigidbody(GameObject obj)
    {
        if (obj == null) return;

        MeshFilter meshFilter = obj.GetComponent<MeshFilter>();
        if (meshFilter != null) {
            if (meshFilter.sharedMesh == null) {
                Debug.LogWarning($"MeshFilter on {obj.name} has no sharedMesh.");
            }
            else {
                bool meshColliderAdded = false;

                try {
                    MeshCollider meshCollider = obj.AddComponent<MeshCollider>();
                    meshCollider.sharedMesh = meshFilter.sharedMesh;
                    meshColliderAdded = true;

                    // fobOp̃bZ[W
                    Debug.Log($"Added MeshCollider to {obj.name}");
                }
                catch (System.Exception e) {
                    Debug.LogError($"Failed to add MeshCollider to {obj.name}: {e.Message}");
                }

                // MeshCollider ̒ǉɎsꍇAփRC_[ǉ
                if (!meshColliderAdded) {
                    BoxCollider boxCollider = obj.AddComponent<BoxCollider>();
                    Debug.LogWarning($"Added BoxCollider to {obj.name} as a fallback");
                }

                // Rigidbody R|[lg̒ǉ
                if (obj.GetComponent<Rigidbody>() == null) {
                    Rigidbody rb = obj.AddComponent<Rigidbody>();
                    if (rb !=NULL) rb.isKinematic = true; // IuWFNgÎ~Ăꍇ
                }
            }
        }
        else {
            Debug.Log($"No MeshFilter found on {obj.name}");
        }
    }
}