// Copyright Epic Games, Inc. All Rights Reserved.

#include "SetLocationByParameterStyle.h"
#include "SetLocationByParameter.h"
#include "Framework/Application/SlateApplication.h"
#include "Styling/SlateStyleRegistry.h"
#include "Slate/SlateGameResources.h"
#include "Interfaces/IPluginManager.h"
#include "Styling/SlateStyleMacros.h"

#define RootToContentDir Style->RootToContentDir

TSharedPtr<FSlateStyleSet> FSetLocationByParameterStyle::StyleInstance = nullptr;

void FSetLocationByParameterStyle::Initialize()
{
	if (!StyleInstance.IsValid())
	{
		StyleInstance = Create();
		FSlateStyleRegistry::RegisterSlateStyle(*StyleInstance);
	}
}

void FSetLocationByParameterStyle::Shutdown()
{
	FSlateStyleRegistry::UnRegisterSlateStyle(*StyleInstance);
	ensure(StyleInstance.IsUnique());
	StyleInstance.Reset();
}

FName FSetLocationByParameterStyle::GetStyleSetName()
{
	static FName StyleSetName(TEXT("SetLocationByParameterStyle"));
	return StyleSetName;
}


const FVector2D Icon16x16(16.0f, 16.0f);
const FVector2D Icon20x20(20.0f, 20.0f);

TSharedRef< FSlateStyleSet > FSetLocationByParameterStyle::Create()
{
	TSharedRef< FSlateStyleSet > Style = MakeShareable(new FSlateStyleSet("SetLocationByParameterStyle"));
	Style->SetContentRoot(IPluginManager::Get().FindPlugin("SetLocationByParameter")->GetBaseDir() / TEXT("Resources"));

	Style->Set("SetLocationByParameter.PluginAction", new IMAGE_BRUSH_SVG(TEXT("PlaceholderButtonIcon"), Icon20x20));
	return Style;
}

void FSetLocationByParameterStyle::ReloadTextures()
{
	if (FSlateApplication::IsInitialized())
	{
		FSlateApplication::Get().GetRenderer()->ReloadTextureResources();
	}
}

const ISlateStyle& FSetLocationByParameterStyle::Get()
{
	return *StyleInstance;
}
