;;; File:     utils1.clp
;;; Purpose:  General CLIPS utilities for HARDY
;;; Author:   Julian Smart
;;; Created:  16/7/94
;;;
;;;

;;; Convert a multi-value list of strings to one string
(deffunction many-strings-to-one ($?strings)
  (bind ?counter 1)
  (bind ?string "")
  (while (<= ?counter (length $?strings)) do
    (bind ?string (str-cat ?string (nth ?counter $?strings)))
    (bind ?counter (+ ?counter 1))
  )
  (return ?string)
)

;;; Get the path only, given a full filename
;;; E.g. c:\thing\test.txt -> c:\thing

(deffunction get-path (?filename)
 (bind ?pos (length ?filename))
 (bind ?found FALSE)
 (while (and (> ?pos 1) (neq ?found TRUE))
  (bind ?char (sub-string ?pos ?pos ?filename))
  ; Find the first backslash from the end
  (if (eq ?char "\\") then
   (bind ?found TRUE)
  else
   (bind ?pos (- ?pos 1)))
 )
 (if (eq ?found TRUE) then
  (if (> ?pos 1) then (return (sub-string 1 (- ?pos 1) ?filename))
   else (return ""))
 else (return ""))
)

;;; Get the filename only, given a full path
;;; E.g. c:\thing\test.txt -> test.txt

(deffunction get-file (?filename)
 (bind ?pos (length ?filename))
 (bind ?found FALSE)
 (while (and (> ?pos 1) (neq ?found TRUE))
  (bind ?char (sub-string ?pos ?pos ?filename))
  ; Find the first backslash from the end
  (if (eq ?char "\\") then
   (bind ?found TRUE)
  else
   (bind ?pos (- ?pos 1)))
 )
 (if (eq ?found TRUE) then
  (if (> ?pos 1) then (return (sub-string (+ ?pos 1) (length ?filename) ?filename))
   else (return ?filename))
 else (return ?filename))
)

;;; Strip extension
(deffunction strip-extension (?filename)
 (bind ?pos (length ?filename))
 (bind ?found FALSE)
 (while (and (> ?pos 1) (neq ?found TRUE))
  (bind ?char (sub-string ?pos ?pos ?filename))
  ; Find the first dot from the end
  (if (eq ?char ".") then
   (bind ?found TRUE)
  else
   (bind ?pos (- ?pos 1)))
 )
 (if (eq ?found TRUE) then
  (if (> ?pos 1) then (return (sub-string 1 (- ?pos 1) ?filename))
   else (return ?filename))
 else (return ?filename))
)

