/*
 * custom.cc
 * File generated by Clips2C from tree.clp
 * for HARDY compatibility
 */

#include "math.h"
#include "stdlib.h"
#include "wxstring.h"
#include "clipslib.h"
#include "wx_cmds.h"
#include "hapi.h"

/*
 * Function prototypes
 */

void tree_add_root_image(long card_id);
void tree_menu_handler(long card_id, wxString option);
void tree_node_handler(long card_id, long image_id, float x, float y, long shift, long control);
void tree_delete_image_handler(long card_id, long image_id, wxString type);

/*
 * Global variables
 */

long _tree_root_ = 0;

/*
 * Classes
 */


/*
 * Functions
 */

void tree_add_root_image(long card_id)
{
  wxString msg;
  long image1;
  long object1;
  msg = wxString(wxcGetTextFromUser("Enter name for new root node"));
  if ((msg == wxString("")))
  {
0;
  }
  else
  {
    image1 = HardyNodeImageCreate(card_id, "Node");
    object1 = HardyDiagramImageGetObject(card_id, image1);
    HardyDiagramObjectSetStringAttribute(card_id, object1, "name", msg.GetData());
    HardyDiagramObjectFormatText(card_id, object1);
    _tree_root_ = image1;
    HardyDiagramCardLayoutTree(card_id, _tree_root_);
  }
;
}

void tree_menu_handler(long card_id, wxString option)
{
  if ((option == wxString("Add root")))
  {
    tree_add_root_image(card_id);
  }
  else
  {
    if ((option == wxString("Layout tree")))
    {
      HardyDiagramCardLayoutTree(card_id, _tree_root_);
    }
;
  }
;
}

void tree_node_handler(long card_id, long image_id, float x, float y, long shift, long control)
{
  wxString msg;
  long image1;
  long object1;
  long image3;
;
;
  if (((shift != 1) && (control != 1)))
  {
    msg = wxString(wxcGetTextFromUser("Enter name for new node"));
    if ((msg == wxString("")))
    {
0;
    }
    else
    {
      image1 = HardyNodeImageCreate(card_id, "Node");
      object1 = HardyDiagramImageGetObject(card_id, image1);
      HardyDiagramObjectSetStringAttribute(card_id, object1, "name", msg.GetData());
      HardyDiagramObjectFormatText(card_id, object1);
      image3 = HardyArcImageCreate(card_id, "Arc", image_id, image1, 1, 3);
      HardyDiagramCardLayoutTree(card_id, _tree_root_);
0;
    }
;
  }
  else
  {
1;
  }
;
}

void tree_delete_image_handler(long card_id, long image_id, wxString type)
{
;
  if ((image_id == _tree_root_))
  {
    _tree_root_ = 0;
  }
  else
  {
    HardyDiagramCardLayoutTree(card_id, _tree_root_);
  }
;
}

/*
 * Top-level statements
 */

void ExecuteClipsStatements(void)
{
  HardyRegisterEventHandler("CustomMenu", "Tree", (wxClipsFunction)tree_menu_handler);
  HardyRegisterEventHandler("NodeLeftClick", "Tree", (wxClipsFunction)tree_node_handler);
  HardyRegisterEventHandler("DeleteNodeImage", "Tree", (wxClipsFunction)tree_delete_image_handler);
  HardyRegisterEventHandler("DeleteArcImage", "Tree", (wxClipsFunction)tree_delete_image_handler);
}

/*
 * Initialization function called by HARDY
 */

void gyInitializeCustomCode(void)
{
  ExecuteClipsStatements();
}
