/*
 * gui.cc
 * File generated by Clips2C from hello.clp
 * for HARDY compatibility
 */

#include "math.h"
#include "stdlib.h"
#include "wxstring.h"
#include "clipslib.h"
#include "wx_cmds.h"
#include "hapi.h"

/*
 * Function prototypes
 */

void on_size(long id, long w, long h);
void on_paint(long id);
void on_event(long canvas, long event);
long on_close(long frame);
void on_menu_command(long frame, long id);
void frame_button_proc(long id);
long app_on_init(void);

/*
 * Global variables
 */

long _main_frame_ = 0;
long _subframe_ = 0;
long _panel_ = 0;
long _canvas_ = 0;
long _text_win_ = 0;
long _small_font_ = 0;
long _green_pen_ = 0;
long _black_pen_ = 0;
long _red_pen_ = 0;
long _cyan_brush_ = 0;
float _xpos_ = ((float)-1);
float _ypos_ = ((float)-1);

/*
 * Classes
 */


/*
 * Functions
 */

void on_size(long id, long w, long h)
{
  long client_width;
  long client_height;
;
  if (((id>0) && (_panel_>0) && (_text_win_>0)))
  {
    client_width = wxcWindowGetClientWidth(id);
    client_height = wxcWindowGetClientHeight(id);
    wxcWindowSetSize(_panel_, 0, 0, client_width, (client_height/2));
    wxcWindowSetSize(_text_win_, 0, (client_height/2), client_width, (client_height/2));
  }
;
}

void on_paint(long id)
{
  long dc;
  if ((id>0))
  {
    dc = wxcCanvasGetDC(id);
    wxcDCSetFont(dc, _small_font_);
    wxcDCSetPen(dc, _green_pen_);
    wxcDCDrawLine(dc, ((float)0), ((float)0), ((float)200), ((float)200));
    wxcDCDrawLine(dc, ((float)200), ((float)0), ((float)0), ((float)200));
    wxcDCSetPen(dc, _red_pen_);
    wxcDCSetBrush(dc, _cyan_brush_);
    wxcDCDrawRectangle(dc, ((float)100), ((float)100), ((float)100), ((float)50));
    wxcDCDrawRoundedRectangle(dc, ((float)150), ((float)150), ((float)100), ((float)50));
    wxcDCSetClippingRegion(dc, ((float)150), ((float)150), ((float)100), ((float)50));
    wxcDCDrawText(dc, "This text should be clipped within the rectangle", ((float)150), ((float)170));
    wxcDCDestroyClippingRegion(dc);
    wxcDCDrawEllipse(dc, ((float)250), ((float)250), ((float)100), ((float)50));
    wxcDCDrawSpline(dc, MakeList(new ClipsExpr(((float)50)), new ClipsExpr(((float)200)), new ClipsExpr(((float)50)), new ClipsExpr(((float)100)), new ClipsExpr(((float)200)), new ClipsExpr(((float)10)), NULL));
    wxcDCDrawLine(dc, ((float)50), ((float)230), ((float)200), ((float)230));
    wxcDCDrawText(dc, "This is a test string", ((float)50), ((float)230));
  }
;
}

void on_event(long canvas, long event)
{
  long dc;
  float x;
  float y;
  long dragging;
  dc = wxcCanvasGetDC(canvas);
  wxcDCSetPen(dc, _black_pen_);
  x = wxcMouseEventPositionX(event);
  y = wxcMouseEventPositionY(event);
  dragging = wxcMouseEventDragging(event);
  if (((_xpos_>-1) && (_ypos_>-1) && (dragging>0)))
  {
    wxcDCDrawLine(dc, _xpos_, _ypos_, x, y);
  }
;
  _xpos_ = x;
  _ypos_ = y;
}

long on_close(long frame)
{
;
  ClipsFormat(wxString("t"), TranslateFormat(wxString("Closing frame.%n")));
  wxcWindowDelete(_subframe_);
  return 1;
  return 0;
}

void on_menu_command(long frame, long id)
{
  wxString file;
;
  if (id == 200)
  {
    wxString(wxcMessageBox("CLIPS for wxWindows Demo
by Julian Smart (c) 1993", "About wxWindows CLIPS Demo"));
  }
  else if (id == 3)
  {
    on_close(frame);
    wxcWindowDelete(frame);
  }
  else if (id == 1)
  {
    file = wxString(wxcFileSelector("Choose a text file to load"));
    if ((file != wxString("")))
    {
      wxcTextWindowLoadFile(_text_win_, file.GetData());
    }
;
  }
;
}

void frame_button_proc(long id)
{
  long parent;
  long grandparent;
  parent = wxcWindowGetParent(id);
  grandparent = wxcWindowGetParent(parent);
  ClipsFormat(wxString("t"), TranslateFormat(wxString("Pressed button %d%n")),id);
  wxString(wxcMessageBox("Hello"));
}

long app_on_init(void)
{
  long file_menu;
  long pull_right;
  long help_menu;
  long menu_bar;
  long button;
  long text;
  long choice;
  long check;
  long list;
  long multi;
  long slider;
  if ((_small_font_==0))
  {
    _small_font_ = wxcFontCreate(10, "wxSWISS", "wxNORMAL", "wxNORMAL", 0);
    _green_pen_ = wxcPenCreate("GREEN", 1, "wxSOLID");
    _black_pen_ = wxcPenCreate("BLACK", 1, "wxSOLID");
    _red_pen_ = wxcPenCreate("RED", 3, "wxSOLID");
    _cyan_brush_ = wxcBrushCreate("CYAN", "wxSOLID");
  }
;
  _main_frame_ = wxcFrameCreate(0, "Hello wxCLIPS!", -1, -1, 600, 450);
  wxcFrameCreateStatusLine(_main_frame_);
  wxcFrameSetStatusText(_main_frame_, "Welcome to wxCLIPS");
  wxcWindowAddCallback(_main_frame_, "OnSize", (HardyFunction)on_size);
  wxcWindowAddCallback(_main_frame_, "OnClose", (HardyFunction)on_close);
  wxcWindowAddCallback(_main_frame_, "OnMenuCommand", (HardyFunction)on_menu_command);
  file_menu = wxcMenuCreate();
  wxcMenuAppend(file_menu, 1, "&Load file");
  pull_right = wxcMenuCreate();
  wxcMenuAppend(pull_right, 100, "&Twips");
  wxcMenuAppend(pull_right, 101, "&10th mm");
  wxcMenuAppend(file_menu, 2, "&Scale picture", pull_right);
  wxcMenuAppendSeparator(file_menu);
  wxcMenuAppend(file_menu, 3, "&Quit");
  help_menu = wxcMenuCreate();
  wxcMenuAppend(help_menu, 200, "&About");
  menu_bar = wxcMenuBarCreate();
  wxcMenuBarAppend(menu_bar, file_menu, "&File");
  wxcMenuBarAppend(menu_bar, help_menu, "&Help");
  wxcFrameSetMenuBar(_main_frame_, menu_bar);
  _panel_ = wxcPanelCreate(_main_frame_, 0, 0, 500, 250);
  wxcPanelSetLabelPosition(_panel_, "wxVERTICAL");
  _text_win_ = wxcTextWindowCreate(_main_frame_, 0, 250, 500, 300);
  button = wxcButtonCreate(_panel_, (HardyFunction)frame_button_proc, "A button");
  text = wxcTextCreate(_panel_, (HardyFunction)NULL, "A text item", "Initial value", -1, -1, 200);
  choice = wxcChoiceCreate(_panel_, (HardyFunction)NULL, "A choice item");
  wxcChoiceAppend(choice, "One");
  wxcChoiceAppend(choice, "Two");
  wxcChoiceAppend(choice, "Three");
  wxcChoiceAppend(choice, "Four");
  check = wxcCheckBoxCreate(_panel_, (HardyFunction)NULL, "A check box");
  wxcPanelNewLine(_panel_);
  list = wxcListBoxCreate(_panel_, (HardyFunction)NULL, "A list", 0, -1, -1, 100, 100);
  wxcListBoxAppend(list, "Apple");
  wxcListBoxAppend(list, "Pear");
  wxcListBoxAppend(list, "Orange");
  wxcListBoxAppend(list, "Banana");
  wxcListBoxAppend(list, "Fruit");
  multi = wxcMultiTextCreate(_panel_, (HardyFunction)NULL, "Multiline text", "Some text", -1, -1, 150, 100);
  slider = wxcSliderCreate(_panel_, (HardyFunction)NULL, "A slider", 40, 22, 101, 180);
  wxcMessageCreate(_panel_, "A simple message");
  wxcTextWindowLoadFile(_text_win_, "hello.clp");
  _subframe_ = wxcFrameCreate(0, "Canvas Frame", 300, 300, 400, 400);
  _canvas_ = wxcCanvasCreate(_subframe_, 0, 0, 400, 400);
  wxcWindowAddCallback(_canvas_, "OnPaint", (HardyFunction)on_paint);
  wxcWindowAddCallback(_canvas_, "OnEvent", (HardyFunction)on_event);
  wxcCanvasSetScrollbars(_canvas_, 20, 20, 50, 50, 4, 4);
  wxcWindowShow(_subframe_, 1);
  wxcWindowShow(_main_frame_, 1);
  return _main_frame_;
  return 0;
}

/*
 * Top-level statements
 */

void ExecuteClipsStatements(void)
{
  app_on_init();
}

/*
 * Initialization function called by HARDY
 */

void gyInitializeCustomCode(void)
{
  ExecuteClipsStatements();
}
