;;; ======================================================================
;;; wx_text.clp
;;; ======================================================================

(defclass MAIN::wxTextWindow (is-a wxWindow)
	(role concrete)
)

;;; ======================================================================
;;; DEFMESSAGE-HANDLERS
;;; ======================================================================

(defmessage-handler MAIN::wxTextWindow create ()

        (send ?self win-init)

	;; Create the text window.
        (bind ?parent-id 0)
        (if (neq ?self:parent nil) then (bind ?parent-id (send ?self:parent get-id)))
	(bind ?self:id
		(text-window-create	?parent-id
				?self:x
				?self:y
				?self:width
				?self:height
				?self:style
				?self:window-name
        ))
        (instance-table-add-entry ?self:id (instance-name ?self))
        (send ?self add-event-handlers)
)

(defmessage-handler MAIN::wxTextWindow clear ()
  (return (long-to-bool (text-window-clear ?self:id)))
)

(defmessage-handler MAIN::wxTextWindow discard-edits ()
  (text-window-discard-edits ?self:id)
)

(defmessage-handler MAIN::wxTextWindow copy ()
  (return (long-to-bool (text-window-copy ?self:id)))
)

(defmessage-handler MAIN::wxTextWindow cut ()
  (return (long-to-bool (text-window-cut ?self:id)))
)

(defmessage-handler MAIN::wxTextWindow get-contents ()
  (return (text-window-get-contents ?self:id))
)

(defmessage-handler MAIN::wxTextWindow set-editable (?editable)
  (return (long-to-bool (text-window-set-editable ?self:id ?editable)))
)

(defmessage-handler MAIN::wxTextWindow paste ()
  (return (long-to-bool (text-window-paste ?self:id)))
)

(defmessage-handler MAIN::wxTextWindow load-file (?filename)
  (return (long-to-bool (text-window-load-file ?self:id ?filename)))
)

(defmessage-handler MAIN::wxTextWindow save-file (?filename)
  (return (long-to-bool (text-window-save-file ?self:id ?filename)))
)

(defmessage-handler MAIN::wxTextWindow write (?text)
  (return (long-to-bool (text-window-write ?self:id ?text)))
)

(defmessage-handler MAIN::wxTextWindow modified ()
  (return (long-to-bool (text-window-modified ?self:id)))
)


