;;; wx_test.clp
;;; Duplicates the hello.clp demo, but using wxCOOL.

(defclass MAIN::MyFrame (is-a wxFrame)
  (role concrete)

  (slot panel
    (create-accessor read-write)
    (visibility public)
    (default nil))

  (slot text-window
    (create-accessor read-write)
    (visibility public)
    (default nil))
)

(defclass MAIN::MyPanel (is-a wxPanel)
  (role concrete)
)

(defmessage-handler MAIN::MyFrame on-size (?w ?h)
  ; Calls frame-on-size to do default frame layout
  ;  (call-next-handler)

  (if (and (neq ?self:panel nil) (neq ?self:text-window nil)) then
    (bind ?client-width (send ?self get-client-width))
    (bind ?client-height (send ?self get-client-height))
    (send ?self:panel set-size 0 0 ?client-width (* ?client-height 0.666))
    (send ?self:text-window set-size 0 (* ?client-height 0.666) ?client-width (/ ?client-height 3))
  )
)

(defmessage-handler MAIN::MyFrame on-close ()
  (return TRUE)
)

(defmessage-handler MAIN::MyPanel on-command (?item ?command-event)
  (printout t "*** MyPanel Got item event" crlf)
  (printout t "*** Item has name " (send ?item get-window-name) ", class " (class ?item) crlf)
)

(defmessage-handler MAIN::MyFrame on-menu-command (?command)
  (printout t "*** MyFrame Got menu item command " ?command crlf)
  (switch ?command
    (case 1 then (printout t "Open a file" crlf))
    (case 2 then (printout t "Close a file" crlf))
    (case 3 then (send ?self delete))
  )
)

(deffunction app-on-init ()
 (wxcool-init)

 (make-instance [*small-font*] of wxFont (point-size 10) (family wxSWISS) (style wxNORMAL) (weight wxNORMAL)
   (underlined FALSE))
 (make-instance [*green-pen*] of wxPen (colour "GREEN") (width 1) (style wxSOLID))
 (make-instance [*black-pen*] of wxPen (colour "BLACK") (width 1) (style wxSOLID))
 (make-instance [*red-pen*] of wxPen (colour "RED") (width 3) (style wxSOLID))
 (make-instance [*cyan-brush*] of wxBrush (colour "CYAN") (style wxSOLID))
 (make-instance [*hand-cursor*] of wxCursor (cursor-name "wxCURSOR_HAND"))

 (if (eq "Windows 3.1" (get-platform)) then
   (make-instance [*bitmap*] of wxBitmap (filename "../examples/wxwin.bmp") (bitmap-type "wxBITMAP_TYPE_BMP"))
   (make-instance [*button-bitmap*] of wxBitmap (filename "../examples/aiai.bmp") (bitmap-type "wxBITMAP_TYPE_BMP"))
   (make-instance [*icon*] of wxIcon (filename "../examples/aiai.ico") (bitmap-type "wxBITMAP_TYPE_ICO"))
 )

 (make-instance [*main-frame*] of MyFrame (title "Hello wxCOOL!") (x 20) (y 20) (width 500) (height 460))

 (send [*main-frame*] create-status-line)
 (send [*main-frame*] set-status-text "Welcome to wxCOOL")

 (if (instance-existp [*icon*]) then (send [*main-frame*] set-icon [*icon*]))

 (make-instance [file-menu] of wxMenu)
 (send [file-menu] append 1 "&Load file")
 (send [file-menu] append 4 "&Print to PostScript")

 (make-instance [pull-right] of wxMenu)
 (send [pull-right] append 100 "&Twips")
 (send [pull-right] append 101 "&10th mm")

 (send [file-menu] append 2 "&Scale picture" [pull-right])
 (send [file-menu] append-separator)
 (send [file-menu] append 3 "E&xit")
 
 (make-instance [help-menu] of wxMenu)
 (send [help-menu] append 200 "&About")

 (make-instance [menu-bar] of wxMenuBar)
 (send [menu-bar] append [file-menu] "&File")
 (send [menu-bar] append [help-menu] "&Help")

 (send [*main-frame*] set-menu-bar [menu-bar])
 
  ;;; Make a panel and panel items
 (send [*main-frame*] put-panel (make-instance [*panel*] of MyPanel (parent [*main-frame*])))
 (send [*panel*] set-label-position wxVERTICAL)
 
 (send [*main-frame*] put-text-window (make-instance [*text-win*] of wxTextWindow (parent [*main-frame*])))

 (make-instance buttontest1 of wxButton (parent [*panel*]) (label "Button") (window-name "MyButton1"))
 (make-instance bitmap1 of wxBitmap (filename "../examples/aiai.bmp") (bitmap-type wxBITMAP_TYPE_BMP))
 (make-instance buttontest2 of wxButton (parent [*panel*]) (bitmap [bitmap1]) (window-name "MyButton2"))
 
 (send [*main-frame*] show TRUE)
 (return (send [*main-frame*] get-id))
)
