;;; ======================================================================
;;; wx_tbar.clp
;;; ======================================================================

; Change wxPanel to wxCanvas under XView
(defclass MAIN::wxToolBar (is-a wxPanel)
  (role concrete)

  (slot orientation
    (create-accessor read-write)
    (access initialize-only)
    (visibility public)
    (type STRING)
    (default "wxVERTICAL"))
  (slot rows-or-columns
    (create-accessor read-write)
    (access initialize-only)
    (visibility public)
    (type INTEGER)
    (default 30))
  (slot create-buttons
    (create-accessor read-write)
    (access initialize-only)
    (visibility public)
    (type SYMBOL)
    (default TRUE))
)

;;; ======================================================================
;;; DEFMESSAGE-HANDLERS
;;; ======================================================================

(defmessage-handler MAIN::wxToolBar create ()

        (send ?self win-init)

	;; Create the toolbar.
        (bind ?parent-id 0)
        (if (neq ?self:parent nil) then (bind ?parent-id (send ?self:parent get-id)))
	(bind ?self:id
		(toolbar-create	?parent-id
				?self:x
				?self:y
				?self:width
				?self:height
				?self:style
				?self:orientation
				?self:rows-or-columns
				(bool-to-long ?self:create-buttons)
				?self:window-name
        ))
        (instance-table-add-entry ?self:id (instance-name ?self))
        (send ?self add-event-handlers)
)

(defmessage-handler MAIN::wxToolBar add-tool (?index ?bitmap-id1 $?args)
  (bind ?bitmap-id2 (nth$ 1 ?args))
  (bind ?is-toggle (nth$ 2 ?args))
  (bind ?x (nth$ 3 ?args))
  (bind ?y (nth$ 4 ?args))
  (bind ?client-data (nth$ 5 ?args))
  (bind ?help-string1 (nth$ 6 ?args))
  (bind ?help-string2 (nth$ 7 ?args))

  (if (eq ?bitmap-id2 nil) then (bind ?bitmap-id2 0) else
   (bind ?bitmap-id2 (send ?bitmap-id2 get-id)))

  (if (eq ?is-toggle nil) then (bind ?is-toggle FALSE) else
   (bind ?is-toggle (bool-to-long ?is-toggle)))

  (if (eq ?x nil) then (bind ?x -1.0))
  (if (eq ?y nil) then (bind ?y -1.0))

  (if (eq ?client-data nil) then (bind ?client-data 0))
  (if (eq ?help-string1 nil) then (bind ?help-string1 ""))
  (if (eq ?help-string2 nil) then (bind ?help-string2 ""))

  (return (long-to-bool (toolbar-add-tool ?self:id ?index ?bitmap-id1 ?bitmap-id2
   ?is-toggle ?x ?y ?client-data ?help-string1 ?help-string2)))
)

(defmessage-handler MAIN::wxToolBar add-separator ()
 (return (long-to-bool (toolbar-add-separator ?self:id)))
)

(defmessage-handler MAIN::wxToolBar clear-tools ()
  (return (long-to-bool (toolbar-clear-tools ?self:id)))
)

(defmessage-handler MAIN::wxToolBar create-tools ()
  (return (long-to-bool (toolbar-create-tools ?self:id)))
)

(defmessage-handler MAIN::wxToolBar enable-tool (?tool-id ?enable)
  (return (long-to-bool (toolbar-enable-tool ?self:id ?tool-id (bool-to-long ?enable))))
)

(defmessage-handler MAIN::wxToolBar get-tool-short-help (?tool-id)
  (return (toolbar-get-tool-short-help ?self:id ?tool-id))
)

(defmessage-handler MAIN::wxToolBar get-tool-long-help (?tool-id)
  (return (toolbar-get-tool-long-help ?self:id ?tool-id))
)

(defmessage-handler MAIN::wxToolBar set-tool-short-help (?tool-id ?help)
  (return (long-to-bool (toolbar-set-tool-short-help ?self:id ?tool-id ?help)))
)

(defmessage-handler MAIN::wxToolBar set-tool-long-help (?tool-id ?help)
  (return (long-to-bool (toolbar-set-tool-long-help ?self:id ?tool-id ?help)))
)

(defmessage-handler MAIN::wxToolBar get-max-height ()
  (return (toolbar-get-max-height ?self:id))
)

(defmessage-handler MAIN::wxToolBar get-max-width ()
  (return (toolbar-get-max-width ?self:id))
)

(defmessage-handler MAIN::wxToolBar get-tool-client-data (?tool-id)
  (return (toolbar-get-tool-client-data ?self:id ?tool-id))
)

(defmessage-handler MAIN::wxToolBar get-tool-enabled (?tool-id)
  (return (long-to-bool (toolbar-get-tool-enabled ?self:id ?tool-id)))
)

(defmessage-handler MAIN::wxToolBar get-tool-state (?tool-id)
  (return (long-to-bool (toolbar-get-tool-state ?self:id ?tool-id)))
)

(defmessage-handler MAIN::wxToolBar layout ()
  (return (long-to-bool (toolbar-layout ?self:id)))
)

(defmessage-handler MAIN::wxToolBar on-paint ()
  (toolbar-on-paint ?self:id)
)

(defmessage-handler MAIN::wxToolBar set-default-size (?width ?height)
  (return (long-to-bool (toolbar-set-default-size ?self:id ?width ?height)))
)

(defmessage-handler MAIN::wxToolBar set-margins (?x ?y)
  (return (long-to-bool (toolbar-set-margins ?self:id ?x ?y)))
)

(defmessage-handler MAIN::wxToolBar toggle-tool (?tool-id ?toggle)
  (return (long-to-bool (toolbar-toggle-tool ?self:id ?tool-id ?toggle)))
)


