;;; ======================================================================
;;; wx_panel.clp
;;; ======================================================================

(defclass MAIN::wxPanel (is-a wxCanvas)
	(slot resource
		(create-accessor read-write)
		(access initialize-only)
		(visibility public)
		(type STRING)
		(default ""))

	(role concrete)
)

;;; ======================================================================
;;; DEFMESSAGE-HANDLERS
;;; ======================================================================

(defmessage-handler MAIN::wxPanel create ()
  
        (send ?self win-init)

	;; Create the panel.
        
        (bind ?parent-id 0)
        (if (neq ?self:parent nil) then (bind ?parent-id (send ?self:parent get-id)))

        (if (neq ?self:resource "") then
          (bind ?self:id (panel-create-from-resource ?parent-id ?self:resource))
          (send ?self create-child-objects)
         else
  	  (bind ?self:id
		(panel-create	?parent-id
				?self:x
				?self:y
				?self:width
				?self:height
				?self:style
				?self:window-name
        )))
        (if (> ?self:id 0) then
          (bind ?self:dc (make-instance (gensym) of wxCanvasDC (id (canvas-get-dc ?self:id))))
          (instance-table-add-entry ?self:id (instance-name ?self))
          (send ?self add-event-handlers))
)

; See wx_item.clp for 
;(defmessage-handler MAIN::wxPanel create-child-objects ()

(defmessage-handler MAIN::wxPanel set-button-font (?font)
  (return (long-to-bool (panel-set-button-font ?self:id ?font)))
)

(defmessage-handler MAIN::wxPanel set-label-font (?font)
  (return (long-to-bool (panel-set-label-font ?self:id ?font)))
)

(defmessage-handler MAIN::wxPanel set-label-position (?pos)
  (return (long-to-bool (panel-set-label-position ?self:id ?pos)))
)

(defmessage-handler MAIN::wxPanel new-line ()
  (return (long-to-bool (panel-new-line ?self:id)))
)

(defmessage-handler MAIN::wxPanel on-default-action (?item)
)

(defmessage-handler MAIN::wxPanel on-command (?item ?event)
)

;;; OnDefaultAction callback
(deffunction gui-panel-on-default-action (?panel-id ?item-id)
  (bind ?panel-inst (instance-table-get-instance ?panel-id))
  (bind ?item-inst (instance-table-get-instance ?item-id))
  (if (and (neq ?panel-inst "") (neq ?item-inst ""))
     then (send (send ?panel-inst get-event-handler) on-default-action ?item-inst))
 )

;;; OnCommand callback
(deffunction gui-panel-on-command (?panel-id ?item-id ?command-event)
  (bind ?panel-inst (instance-table-get-instance ?panel-id))
  (bind ?item-inst (instance-table-get-instance ?item-id))
  (send [wxglobal-command-event] put-id ?command-event)
  (if (and (neq ?panel-inst "") (neq ?item-inst ""))
     then (send (send ?panel-inst get-event-handler) on-command ?item-inst [wxglobal-command-event]))
 )

(defmessage-handler MAIN::wxPanel add-event-handlers primary ()
  (call-next-handler)

  (window-add-callback ?self:id OnDefaultAction     gui-panel-on-default-action)
  (window-add-callback ?self:id OnCommand           gui-panel-on-command)
)
