;;; ======================================================================
;;; wx_obj.clp
;;; Base object class
;;; ======================================================================

;;; ----------------------------------------------------------------------
;;; CLASS:
;;;	wxObject
;;; SUPERCLASS:
;;;	USER
;;; DESCRIPTION:
;;;	This is the base class from which all other wxCOOL
;;;	classes inherit.
;;; ----------------------------------------------------------------------

(defclass MAIN::wxObject (is-a USER)
	(role abstract)
	(slot id
		(create-accessor read-write)
		(visibility public)
		(type INTEGER)
		(default 0))
	(slot pending-delete
		(create-accessor read-write)
		(visibility public)
		(type SYMBOL)
		(default FALSE))
        ; Set this to TRUE when creating an instance whose underlying object
        ; has already been created, e.g. when creating objects to wrap
        ; objects that have been created implicitly by loading a resource.
        (slot dont-create
		(create-accessor read-write)
		(visibility public)
		(type SYMBOL)
		(default FALSE))
        
)

(defmessage-handler MAIN::wxObject init after ()
;  (printout t "*** wxObject init" crlf)
  (send ?self create)
)

;;; Empty base creation handler
(defmessage-handler MAIN::wxObject create ()
)

;;; OnDelete callback
(deffunction gui-object-on-delete (?id)
;  (printout t "*** on-delete " ?id crlf)
  
  (bind ?inst (instance-table-get-instance ?id))
  (if (and (instance-existp ?inst) (not (send ?inst get-pending-delete)))
    then

    ;;; We don't want to delete the object twice, so
    ;;; set a flag to indicate we're in a delete
    ;;; already.
    (send ?inst put-pending-delete TRUE)
;    (printout t "*** Deleting " ?inst crlf)
    (instance-table-delete-entry ?id)
    (send ?inst delete)
  )
 )

(defmessage-handler MAIN::wxObject add-event-handlers primary ()
  (window-add-callback ?self:id OnDelete    gui-object-on-delete)
)

