;;; misc.clp
;;; Miscellaneous utilities

(deffunction bool-to-long (?arg)
  (if ?arg then (return 1) else (return 0))
)

(deffunction long-to-bool (?arg)
  (return (= ?arg 1))
)

; Returns TRUE if the id is NOT 0 or -1 (allowing
; for 32-bit versions of wxCLIPS where ids can be negative).
(deffunction valid-id (?id)
 (return (and (numberp ?id) (not (or (= ?id 0) (= ?id -1))))))

