;;; ======================================================================
;;; wx_menu.clp
;;; Menu and menu bar
;;; ======================================================================

;;; ======================================================================
;;; CLASS wxMenu
;;; ======================================================================

(defclass MAIN::wxMenu (is-a wxWindow)
  (role concrete)
  (slot label
    (create-accessor read-write)
    (visibility public)
    (type STRING)
    (default ""))
  (slot callback
    (create-accessor read-write)
    (visibility public)
    (default nil))
)

;;; ======================================================================
;;; CLASS wxMenuBar
;;; ======================================================================

(defclass MAIN::wxMenuBar (is-a wxWindow)
  (role concrete)

  (slot resource
    (create-accessor read-write)
    (visibility public)
    (type STRING)
    (default ""))
)

;;; ======================================================================
;;; DEFMESSAGE-HANDLERS for wxMenu
;;; ======================================================================

;;; Generic callback for all popup menus
(deffunction gui-menu-item-callback (?id)
  (bind ?inst (instance-table-get-instance ?id))
  (if (neq ?inst "") then
   (bind ?event-id (panel-item-get-command-event))
   (send [wxglobal-command-event] put-id ?event-id)
   (bind ?cmd (str-cat "(" (string-to-symbol (send ?inst get-callback)) " " ?inst " " wxglobal-command-event ")"))
   (eval ?cmd))
)

(defmessage-handler MAIN::wxMenu create ()
  (send ?self win-init)

  (if (eq ?self:callback nil) then
    (bind ?self:id (menu-create ?self:label)) else
    (bind ?self:id (menu-create ?self:label ?self:callback))
  )
  (instance-table-add-entry ?self:id (instance-name ?self))
  (send ?self add-event-handlers)
)

(defmessage-handler MAIN::wxMenu append (?item-id ?item-string $?rest)
  (bind ?submenu-id (nth$ 1 ?rest))
  (bind ?help-string (nth$ 2 ?rest))
  (bind ?checkable (nth$ 3 ?rest))

  (if (eq ?submenu-id nil) then (bind ?submenu-id -1) else
   (bind ?submenu-id (send ?submenu-id get-id)))
  (if (eq ?help-string nil) then (bind ?help-string ""))
  (if (eq ?checkable nil) then (bind ?checkable 0) else
    (bind ?checkable (bool-to-long ?checkable)))

  (return (long-to-bool (menu-append ?self:id ?item-id ?item-string ?submenu-id ?help-string ?checkable)))
)

(defmessage-handler MAIN::wxMenu append-separator ()
  (return (long-to-bool (menu-append-separator ?self:id)))
)

(defmessage-handler MAIN::wxMenu break ()
  (return (long-to-bool (menu-break ?self:id)))
)

(defmessage-handler MAIN::wxMenu check (?item-id ?check)
  (return (long-to-bool (menu-check ?self:id ?item-id (bool-to-long ?check))))
)

(defmessage-handler MAIN::wxMenu enable (?item-id ?enable)
  (return (long-to-bool (menu-enable ?self:id ?item-id (bool-to-long ?enable))))
)

;;; ======================================================================
;;; DEFMESSAGE-HANDLERS for wxMenuBar
;;; ======================================================================

(defmessage-handler MAIN::wxMenuBar create ()
  (send ?self win-init)

  (if (neq ?self:resource "") then
    (bind ?self:id (menu-bar-create-from-resource ?self:resource))
   else
    (bind ?self:id (menu-bar-create))
  )

  (instance-table-add-entry ?self:id (instance-name ?self))
  (send ?self add-event-handlers)
)

(defmessage-handler MAIN::wxMenuBar append (?menu ?label)
  (return (long-to-bool (menu-bar-append ?self:id (send ?menu get-id) ?label)))
)

(defmessage-handler MAIN::wxMenuBar enable (?item-id ?enable)
  (return (long-to-bool (menu-bar-enable ?self:id ?item-id (bool-to-long ?enable))))
)

(defmessage-handler MAIN::wxMenuBar check (?item-id ?check)
  (return (long-to-bool (menu-bar-check ?self:id ?item-id (bool-to-long ?check))))
)

(defmessage-handler MAIN::wxMenuBar checked (?item-id)
  (return (long-to-bool (menu-bar-checked ?self:id ?item-id)))
)


