;;; ======================================================================
;;; wx_item.clp
;;; Panel items (buttons, text items etc.)
;;; ======================================================================

;;; ======================================================================
;;; CLASS wxItem
;;; ======================================================================

(defclass MAIN::wxItem (is-a wxWindow)
  (role abstract)
  (slot label
    (visibility public)
    (type STRING)
    (default "No Label"))
)

;;; ======================================================================
;;; CLASS wxButton
;;; ======================================================================

(defclass MAIN::wxButton (is-a wxItem)
  (role concrete)
  (slot bitmap
    (create-accessor read-write)
    (visibility public)
    (default nil))
)

;;; ======================================================================
;;; CLASS wxCheckBox
;;; ======================================================================

(defclass MAIN::wxCheckBox (is-a wxItem)
  (role concrete)
  (slot value
    (visibility public)
    (type SYMBOL)
    (default FALSE))
)

;;; ======================================================================
;;; CLASS wxChoice
;;; ======================================================================

(defclass MAIN::wxChoice (is-a wxItem)
  (role concrete)
  (multislot values
    (create-accessor read-write)
    (visibility public)
    (default (create$)))
)

;;; ======================================================================
;;; CLASS wxGauge
;;; ======================================================================

(defclass MAIN::wxGauge (is-a wxItem)
  (role concrete)
  (slot value
    (visibility public)
    (default 1))
  (slot range
    (create-accessor read-write)
    (visibility public)
    (default 100))
)

;;; ======================================================================
;;; CLASS wxGroupBox
;;; ======================================================================

(defclass MAIN::wxGroupBox (is-a wxItem)
  (role concrete)
)

;;; ======================================================================
;;; CLASS wxListBox
;;; ======================================================================

(defclass MAIN::wxListBox (is-a wxItem)
  (role concrete)
  (slot multiple
    (create-accessor read-write)
    (visibility public)
    (type SYMBOL)
    (default FALSE))

;  (slot values
;    (create-accessor read-write)
;    (visibility public)
;    (default (create)))
)

;;; ======================================================================
;;; CLASS wxRadioBox
;;; ======================================================================

(defclass MAIN::wxRadioBox (is-a wxItem)
  (role concrete)
  (slot major-dimension
    (create-accessor read-write)
    (visibility public)
    (type INTEGER)
    (default 0))
  (multislot values
    (create-accessor read-write)
    (visibility public)
    (default (create$)))
)

;;; ======================================================================
;;; CLASS wxSlider
;;; ======================================================================

(defclass MAIN::wxSlider (is-a wxItem)
  (role concrete)
  (slot value
    (visibility public)
    (type INTEGER)
    (default 1))
  (slot min
    (visibility public)
    (type INTEGER)
    (default 1))
  (slot max
    (visibility public)
    (type INTEGER)
    (default 100))
)

;;; ======================================================================
;;; CLASS wxText
;;; ======================================================================

(defclass MAIN::wxText (is-a wxItem)
  (role concrete)
  (slot value
    (visibility public)
    (type STRING)
    (default ""))
)

;;; ======================================================================
;;; CLASS wxMessage
;;; ======================================================================

(defclass MAIN::wxMessage (is-a wxItem)
  (role concrete)
  (slot bitmap
    (create-accessor read-write)
    (visibility public)
    (default nil))
)

;;; ======================================================================
;;; CLASS wxMultiText
;;; ======================================================================

(defclass MAIN::wxMultiText (is-a wxText)
  (role concrete)
)

;;; ======================================================================
;;; DEFMESSAGE-HANDLERS for wxItem
;;; ======================================================================

; Forward on-command event to parent panel
(defmessage-handler MAIN::wxItem on-command primary (?item ?command-event)
 (if (neq ?self:parent nil) then (send ?self:parent on-command ?item ?command-event))
)

(defmessage-handler MAIN::wxItem get-label primary ()
  (if (valid-id ?self:id) then (bind ?self:label (panel-item-get-label ?self:id)))
  (return ?self:label)
)

(defmessage-handler MAIN::wxItem put-label primary (?label)
  (bind ?self:label ?label)
  (if (valid-id ?self:id) then (panel-item-set-label ?self:id ?label))
)

(defmessage-handler MAIN::wxItem set-label primary (?label)
  (send ?self put-label ?label)
)

(defmessage-handler MAIN::wxItem set-default primary ()
  (long-to-bool (panel-item-set-default ?self:id))
)

;;; Generic callback for all items
(deffunction gui-item-callback (?id)
  (bind ?inst (instance-table-get-instance ?id))
  (if (neq ?inst "") then
   (bind ?event-id (panel-item-get-command-event))
   (send [wxglobal-command-event] put-id ?event-id)
   (send (send ?inst get-event-handler) on-command ?inst [wxglobal-command-event]))
)

;;; ======================================================================
;;; DEFMESSAGE-HANDLERS for wxButton
;;; ======================================================================

(defmessage-handler MAIN::wxButton create ()
  (send ?self win-init)

  ;; Create the button.
  (bind ?parent-id 0)
  (if (neq ?self:parent nil) then (bind ?parent-id (send ?self:parent get-id)))

  (if (not ?self:dont-create) then
  
   (if (neq (dynamic-get bitmap) nil) then
  
    (bind ?self:id
      (button-create-from-bitmap
                	?parent-id
                        gui-item-callback
			(send ?self:bitmap get-id)
			?self:x
			?self:y
			?self:width
			?self:height
			?self:style
			?self:window-name
      ))
    else
    (bind ?self:id
       (button-create	?parent-id
                        gui-item-callback
			?self:label
			?self:x
			?self:y
			?self:width
			?self:height
			?self:style
			?self:window-name
      ))
   )
  )
  (instance-table-add-entry ?self:id (instance-name ?self))
  (send ?self add-event-handlers)
)

;(defmessage-handler MAIN::wxButton set-label-bitmap (?bitmap)
;  (return (long-to-bool (button-set-label-bitmap ?self:id (send ?bitmap get-id))))
;)

;;; ======================================================================
;;; DEFMESSAGE-HANDLERS for wxCheckBox
;;; ======================================================================

(defmessage-handler MAIN::wxCheckBox create ()
  (send ?self win-init)

  ;; Create the button.
  (bind ?parent-id 0)
  (if (neq ?self:parent nil) then (bind ?parent-id (send ?self:parent get-id)))

  (if (not ?self:dont-create) then
  
   (bind ?self:id
     (check-box-create
                	?parent-id
                        gui-item-callback
			?self:label
			?self:x
			?self:y
			?self:width
			?self:height
			?self:style
			?self:window-name
      ))
  )
  (instance-table-add-entry ?self:id (instance-name ?self))
  (send ?self add-event-handlers)
)

(defmessage-handler MAIN::wxCheckBox get-value primary ()
  (if (valid-id ?self:id) then (bind ?self:value (long-to-bool (check-box-get-value ?self:id))))
  (return ?self:value)
)

(defmessage-handler MAIN::wxCheckBox put-value primary (?val)
  (if (valid-id ?self:id) then (check-box-set-value ?self:id ?val))
  (bind ?self:value ?val)
)

(defmessage-handler MAIN::wxCheckBox set-value primary (?val)
  (send ?self put-value ?val)
)


;;; ======================================================================
;;; DEFMESSAGE-HANDLERS for wxChoice
;;; ======================================================================

(defmessage-handler MAIN::wxChoice create ()
  (send ?self win-init)

  ;; Create the button.
  (bind ?parent-id 0)
  (if (neq ?self:parent nil) then (bind ?parent-id (send ?self:parent get-id)))

  (if (not ?self:dont-create) then
  
   (bind ?self:id
     (choice-create
                	?parent-id
                        gui-item-callback
			?self:label
			?self:x
			?self:y
			?self:width
			?self:height
			?self:values
			?self:style
			?self:window-name
     ))
  )
  (instance-table-add-entry ?self:id (instance-name ?self))
  (send ?self add-event-handlers)
)

(defmessage-handler MAIN::wxChoice clear ()
  (return (long-to-bool (choice-clear ?self:id)))
)

(defmessage-handler MAIN::wxChoice append (?str-item)
  (return (long-to-bool (choice-append ?self:id ?str-item)))
)

(defmessage-handler MAIN::wxChoice find-string (?str-item)
  (return (choice-find-string ?self:id ?str-item))
)

(defmessage-handler MAIN::wxChoice get-string (?item)
  (return (choice-get-string ?self:id ?item))
)

(defmessage-handler MAIN::wxChoice get-string-selection ()
  (return (choice-get-string-selection ?self:id))
)

(defmessage-handler MAIN::wxChoice get-selection ()
  (return (choice-get-selection ?self:id))
)

(defmessage-handler MAIN::wxChoice set-selection (?item)
  (return (long-to-bool (choice-set-selection ?self:id ?item)))
)

(defmessage-handler MAIN::wxChoice set-string-selection (?str-item)
  (return (long-to-bool (choice-set-string-selection ?self:id ?str-item)))
)


;;; ======================================================================
;;; DEFMESSAGE-HANDLERS for wxGauge
;;; ======================================================================

(defmessage-handler MAIN::wxGauge create ()
  (send ?self win-init)

  ;; Create the button.
  (bind ?parent-id 0)
  (if (neq ?self:parent nil) then (bind ?parent-id (send ?self:parent get-id)))

  (if (not ?self:dont-create) then
  
   (bind ?self:id
     (gauge-create
                	?parent-id
			?self:label
			?self:range
			?self:x
			?self:y
			?self:width
			?self:height
			?self:style
			?self:window-name
     ))
  )
  (instance-table-add-entry ?self:id (instance-name ?self))
  (send ?self add-event-handlers)
)

(defmessage-handler MAIN::wxGauge get-value primary ()
  (return ?self:value)
)

(defmessage-handler MAIN::wxGauge put-value primary (?val)
  (if (valid-id ?self:id) then (gauge-set-value ?self:id ?val))
  (bind ?self:value ?val)
)

(defmessage-handler MAIN::wxGauge set-value primary (?val)
  (send ?self put-value ?val)
)

(defmessage-handler MAIN::wxGauge set-bezel-face (?val)
  (return (long-to-bool (gauge-set-bezel-face ?self:id ?val)))
)

(defmessage-handler MAIN::wxGauge set-shadow-width (?val)
  (return (long-to-bool (gauge-set-shadow-width ?self:id ?val)))
)


;;; ======================================================================
;;; DEFMESSAGE-HANDLERS for wxGroupBox
;;; ======================================================================

(defmessage-handler MAIN::wxGroupBox create ()
  (send ?self win-init)

  ;; Create the button.
  (bind ?parent-id 0)
  (if (neq ?self:parent nil) then (bind ?parent-id (send ?self:parent get-id)))

  (if (not ?self:dont-create) then
  
   (bind ?self:id
    (group-box-create
                	?parent-id
			?self:label
			?self:x
			?self:y
			?self:width
			?self:height
			?self:style
			?self:window-name
     ))
  )
  (instance-table-add-entry ?self:id (instance-name ?self))
  (send ?self add-event-handlers)
)

;;; ======================================================================
;;; DEFMESSAGE-HANDLERS for wxListBox
;;; ======================================================================

(defmessage-handler MAIN::wxListBox create ()
  (send ?self win-init)

  ;; Create the button.
  (bind ?parent-id 0)
  (if (neq ?self:parent nil) then (bind ?parent-id (send ?self:parent get-id)))

  (if (not ?self:dont-create) then
  
   (bind ?self:id
     (list-box-create
                	?parent-id
                        gui-item-callback
			?self:label
			(bool-to-long ?self:multiple)
			?self:x
			?self:y
			?self:width
			?self:height
			?self:style
			?self:window-name
     ))
  )
  (instance-table-add-entry ?self:id (instance-name ?self))
  (send ?self add-event-handlers)
)

(defmessage-handler MAIN::wxListBox clear ()
  (return (long-to-bool (list-box-clear ?self:id)))
)

(defmessage-handler MAIN::wxListBox append (?str-item $?rest)
  (bind ?client-data (nth$ 1 ?rest))
  (if (eq ?client-data nil) then 
    (return (long-to-bool (list-box-append ?self:id ?str-item)))
  else
    (return (long-to-bool (list-box-append ?self:id ?str-item ?client-data))))
)

(defmessage-handler MAIN::wxListBox find-string (?str-item)
  (return (list-box-find-string ?self:id ?str-item))
)

(defmessage-handler MAIN::wxListBox get-string (?item)
  (return (list-box-get-string ?self:id ?item))
)

(defmessage-handler MAIN::wxListBox get-string-selection ()
  (return (list-box-get-string-selection ?self:id))
)

(defmessage-handler MAIN::wxListBox get-selection ()
  (return (list-box-get-selection ?self:id))
)

(defmessage-handler MAIN::wxListBox set-selection (?item)
  (return (long-to-bool (list-box-set-selection ?self:id ?item)))
)

(defmessage-handler MAIN::wxListBox set-string-selection (?str-item)
  (return (long-to-bool (list-box-set-string-selection ?self:id ?str-item)))
)

(defmessage-handler MAIN::wxListBox number ()
  (return (list-box-number ?self:id))
)

(defmessage-handler MAIN::wxListBox delete-item (?item)
  (return (long-to-bool (list-box-delete ?self:id ?item)))
)

(defmessage-handler MAIN::wxListBox get-first-selection ()
  (return (list-box-get-first-selection ?self:id))
)

(defmessage-handler MAIN::wxListBox get-next-selection ()
  (return (list-box-get-next-selection))
)

;;; ======================================================================
;;; DEFMESSAGE-HANDLERS for wxText
;;; ======================================================================

(defmessage-handler MAIN::wxText create ()
  (send ?self win-init)

  ;; Create the button.
  (bind ?parent-id 0)
  (if (neq ?self:parent nil) then (bind ?parent-id (send ?self:parent get-id)))

  (if (not ?self:dont-create) then
  
   (bind ?self:id
     (text-create
                	?parent-id
                        gui-item-callback
			?self:label
			?self:value
                        ?self:x
			?self:y
			?self:width
			?self:height
			?self:style
			?self:window-name
     ))
  )
  (instance-table-add-entry ?self:id (instance-name ?self))
  (send ?self add-event-handlers)
)

(defmessage-handler MAIN::wxText get-value primary ()
  (if (valid-id ?self:id) then (bind ?self:value (text-get-value ?self:id)))
  (return ?self:value)
)

(defmessage-handler MAIN::wxText put-value primary (?val)
  (if (valid-id ?self:id) then (text-set-value ?self:id ?val))
  (bind ?self:value ?val)
)

(defmessage-handler MAIN::wxText set-value primary (?val)
  (send ?self put-value ?val)
)

;;; ======================================================================
;;; DEFMESSAGE-HANDLERS for wxMultiText
;;; ======================================================================

(defmessage-handler MAIN::wxMultiText create ()
  (send ?self win-init)

  ;; Create the button.
  (bind ?parent-id 0)
  (if (neq ?self:parent nil) then (bind ?parent-id (send ?self:parent get-id)))

  (if (not ?self:dont-create) then
  
   (bind ?self:id
     (multi-text-create
                	?parent-id
                        gui-item-callback
			?self:label
			?self:value
                        ?self:x
			?self:y
			?self:width
			?self:height
			?self:style
			?self:window-name
     ))
  )
  (instance-table-add-entry ?self:id (instance-name ?self))
  (send ?self add-event-handlers)
)

;;; ======================================================================
;;; DEFMESSAGE-HANDLERS for wxMessage
;;; ======================================================================

(defmessage-handler MAIN::wxMessage create ()
  (send ?self win-init)

  ;; Create the button.
  (bind ?parent-id 0)
  (if (neq ?self:parent nil) then (bind ?parent-id (send ?self:parent get-id)))

  (if (not ?self:dont-create) then
  
   (if (neq (dynamic-get bitmap) nil) then
  
    (bind ?self:id
       (message-create-from-bitmap
                	?parent-id
			(send ?self:bitmap get-id)
			?self:x
			?self:y
;			?self:width
;			?self:height
			?self:style
			?self:window-name
      ))
    else
   (bind ?self:id
     (message-create
                	?parent-id
			?self:label
                        ?self:x
			?self:y
;			?self:width
;			?self:height
			?self:style
			?self:window-name
      )))
  )
  (instance-table-add-entry ?self:id (instance-name ?self))
  (send ?self add-event-handlers)
)


;;; ======================================================================
;;; DEFMESSAGE-HANDLERS for wxRadioBox
;;; ======================================================================

(defmessage-handler MAIN::wxRadioBox create ()
  (send ?self win-init)

  ;; Create the button.
  (bind ?parent-id 0)
  (if (neq ?self:parent nil) then (bind ?parent-id (send ?self:parent get-id)))

  (if (not ?self:dont-create) then
  
   (bind ?self:id
     (radio-box-create
                	?parent-id
                        gui-item-callback
			?self:label
			?self:x
			?self:y
			?self:width
			?self:height
			?self:values
			?self:major-dimension
			?self:style
			?self:window-name
     ))
  )
  (instance-table-add-entry ?self:id (instance-name ?self))
  (send ?self add-event-handlers)
)

(defmessage-handler MAIN::wxRadioBox get-selection ()
  (return (radio-box-get-selection ?self:id))
)

(defmessage-handler MAIN::wxRadioBox set-selection (?item)
  (return (long-to-bool (radio-box-set-selection ?self:id ?item)))
)

;;; ======================================================================
;;; DEFMESSAGE-HANDLERS for wxSlider
;;; ======================================================================

(defmessage-handler MAIN::wxSlider create ()
  (send ?self win-init)

  ;; Create the button.
  (bind ?parent-id 0)
  (if (neq ?self:parent nil) then (bind ?parent-id (send ?self:parent get-id)))

  (if (not ?self:dont-create) then
  
   (bind ?self:id
     (slider-create
                	?parent-id
                        gui-item-callback
			?self:label
			?self:value
			?self:min
			?self:max
			?self:width
			?self:x
			?self:y
			?self:style
			?self:window-name
     ))
  )
  (instance-table-add-entry ?self:id (instance-name ?self))
  (send ?self add-event-handlers)
)

(defmessage-handler MAIN::wxSlider get-value primary ()
  (if (valid-id ?self:id) then (bind ?self:value (slider-get-value ?self:id)))
  (return ?self:value)
)

(defmessage-handler MAIN::wxSlider put-value primary (?val)
  (if (valid-id ?self:id) then (slider-set-value ?self:id ?val))
  (bind ?self:value ?val)
)

(defmessage-handler MAIN::wxSlider set-value primary (?val)
  (send ?self put-value ?val)
)

;;; Creates an object associated with the ID of each child window
(defmessage-handler MAIN::wxPanel create-child-objects ()
 (bind ?child-id (window-get-next-child ?self:id 0))
 
 (while (neq ?child-id -1)
   (bind ?type (object-get-type ?child-id))
   (bind ?inst nil)
   
   (switch ?type
     (case "wxButton" then (bind ?inst (make-instance (gensym*) of wxButton (parent ?self) (id ?child-id) (dont-create TRUE))))
     (case "wxCheckBox" then (bind ?inst (make-instance (gensym*) of wxCheckBox (parent ?self) (id ?child-id) (dont-create TRUE))))
     (case "wxChoice" then (bind ?inst (make-instance (gensym*) of wxChoice (parent ?self) (id ?child-id) (dont-create TRUE))))
     (case "wxGauge" then (bind ?inst (make-instance (gensym*) of wxGauge (parent ?self) (id ?child-id) (dont-create TRUE))))
     (case "wxGroupBox" then (bind ?inst (make-instance (gensym*) of wxGroupBox (parent ?self) (id ?child-id) (dont-create TRUE))))
     (case "wxListBox" then (bind ?inst (make-instance (gensym*) of wxListBox (parent ?self) (id ?child-id) (dont-create TRUE))))
     (case "wxRadioBox" then (bind ?inst (make-instance (gensym*) of wxRadioBox (parent ?self) (id ?child-id) (dont-create TRUE))))
     (case "wxSlider" then (bind ?inst (make-instance (gensym*) of wxSlider (parent ?self) (id ?child-id) (dont-create TRUE))))
     (case "wxText" then (bind ?inst (make-instance (gensym*) of wxText (parent ?self) (id ?child-id) (dont-create TRUE))))
     (case "wxMultiText" then (bind ?inst (make-instance (gensym*) of wxMultiText (parent ?self) (id ?child-id) (dont-create TRUE))))
     (case "wxMessage" then (bind ?inst (make-instance (gensym*) of wxMultiText (parent ?self) (id ?child-id) (dont-create TRUE))))
   )
   (if (neq ?inst nil) then
     (send ?inst put-window-name (window-get-name ?child-id))
   )
   (bind ?child-id (window-get-next-child ?self:id ?child-id))
 )
)
