;;; ======================================================================
;;; wx_ipc.clp: NOT TESTED YET!!!
;;; ======================================================================

(defclass MAIN::wxServer (is-a wxObject)
  (role concrete)

  (slot service-name
    (create-accessor read-write)
    (access initialize-only)
    (visibility public)
    (type STRING)
    (default ""))
)

(defclass MAIN::wxClient (is-a wxObject)
  (role concrete)
)

(defclass MAIN::wxConnection (is-a wxObject)
  (role concrete)

  (slot service-name
    (create-accessor read-write)
    (access initialize-only)
    (visibility public)
    (type STRING)
    (default ""))
)

;;; ======================================================================
;;; DEFMESSAGE-HANDLERS FOR wxServer
;;; ======================================================================

(defmessage-handler MAIN::wxServer create ()

	;; Create the server.
	(bind ?self:id (server-create ?self:service-name))
        (instance-table-add-entry ?self:id (instance-name ?self))
        (send ?self add-event-handlers)
)

(defmessage-handler MAIN::wxServer on-accept-connection (?topic)
 (printout t "You must override wxServer on-accept-connection to return your wxConnection object." crlf)
 (return nil)
)

(deffunction gui-server-on-accept-connection (?id ?topic ?connection-id)
  (bind ?inst (instance-table-get-instance ?id))
  (if (neq ?inst "") then
    (bind ?connection-inst (send ?inst on-accept-connection ?topic))
    (if (neq ?connection-inst nil) then
      (send ?connection-inst delete)
      (return 0)
     else
      (send ?connection-inst put-id ?connection-id)
      (return 1)
    )
  )
  (return 0)
)

(defmessage-handler MAIN::wxServer add-event-handlers primary ()

  (call-next-handler)

  (window-add-callback ?self:id OnAcceptConnection gui-server-on-accept-connection)
)

;;; ======================================================================
;;; DEFMESSAGE-HANDLERS FOR wxClient
;;; ======================================================================

(defmessage-handler MAIN::wxClient create ()
	;; Create the client.
	(bind ?self:id (client-create))
        (instance-table-add-entry ?self:id (instance-name ?self))
        (send ?self add-event-handlers)
)

(defmessage-handler MAIN::wxClient make-connection (?host ?service-name ?topic)
 (bind ?connection (client-make-connection ?self:id ?host ?service-name ?topic))
 (if (not (valid-id ?connection)) then (return nil)
  else
   (bind ?obj (send ?self on-make-connection))
   (if (neq ?obj nil) then
     (send ?obj put-id ?connection)
     (return ?obj)
     else (return nil)
   )
 )
)

(defmessage-handler MAIN::wxClient on-make-connection ()
 (printout t "You must override wxClient on-make-connection to return your wxConnection object." crlf)
 (return nil)
)

(defmessage-handler MAIN::wxClient add-event-handlers primary ()

  (call-next-handler)
)


;;; ======================================================================
;;; DEFMESSAGE-HANDLERS FOR wxConnection
;;; ======================================================================

(defmessage-handler MAIN::wxConnection create ()
	;; Create the connection.
        (if (neq ?self:id 0) then
          (instance-table-add-entry ?self:id (instance-name ?self))
        )
        (send ?self add-event-handlers)
)

(defmessage-handler MAIN::wxConnection put-id (?id)
  (if (neq ?self:id 0) then
    (instance-table-add-entry ?self:id (instance-name ?self))
  )
  (return TRUE)
)

(defmessage-handler MAIN::wxConnection advise (?item ?data)
  (return (long-to-bool (connection-advise ?self:id ?item ?data)))
)

(defmessage-handler MAIN::wxConnection advise (?data)
  (return (long-to-bool (connection-execute ?self:id ?data)))
)

(defmessage-handler MAIN::wxConnection disconnect ()
  (bind ?ret (long-to-bool (connection-disconnect ?self:id)))
  (send ?self delete)
  (return ?ret)
)

(defmessage-handler MAIN::wxConnection poke (?item ?data)
  (return (long-to-bool (connection-poke ?self:id ?item ?data)))
)

(defmessage-handler MAIN::wxConnection request (?item)
  (return (connection-request ?self:id ?item))
)

(defmessage-handler MAIN::wxConnection start-advise (?item)
  (return (long-to-bool (connection-start-advise ?self:id ?item)))
)

(defmessage-handler MAIN::wxConnection stop-advise (?item)
  (return (long-to-bool (connection-stop-advise ?self:id ?item)))
)

(defmessage-handler MAIN::wxConnection on-advise (?topic ?item ?data)
 (return TRUE)
)

(defmessage-handler MAIN::wxConnection on-execute (?topic ?data)
 (return TRUE)
)

(defmessage-handler MAIN::wxConnection on-poke (?topic ?item ?data)
 (return TRUE)
)

(defmessage-handler MAIN::wxConnection on-request (?topic ?item)
 (return "")
)

(defmessage-handler MAIN::wxConnection on-start-advise (?topic ?item)
 (return TRUE)
)

(defmessage-handler MAIN::wxConnection on-stop-advise (?topic ?item)
 (return TRUE)
)

(deffunction gui-connection-on-advise (?id ?message ?topic ?item ?data)
  (bind ?inst (instance-table-get-instance ?id))
  (if (neq ?inst "") then
    (return (bool-to-long (send ?inst on-advise ?topic ?item ?data)))
  )
  (return 1)
)

(deffunction gui-connection-on-execute (?id ?message ?topic ?item ?data)
  (bind ?inst (instance-table-get-instance ?id))
  (if (neq ?inst "") then
    (return (bool-to-long (send ?inst on-execute ?topic ?data)))
  )
  (return 1)
)

(deffunction gui-connection-on-poke (?id ?message ?topic ?item ?data)
  (bind ?inst (instance-table-get-instance ?id))
  (if (neq ?inst "") then
    (return (bool-to-long (send ?inst on-poke ?topic ?item ?data)))
  )
  (return 1)
)

(deffunction gui-connection-on-request (?id ?message ?topic ?item ?data)
  (bind ?inst (instance-table-get-instance ?id))
  (if (neq ?inst "") then
    (return (send ?inst on-request ?topic ?item))
  )
  (return "")
)

(deffunction gui-connection-on-start-advise (?id ?message ?topic ?item ?data)
  (bind ?inst (instance-table-get-instance ?id))
  (if (neq ?inst "") then
    (return (bool-to-long (send ?inst on-start-advise ?topic ?item)))
  )
  (return 1)
)

(deffunction gui-connection-on-stop-advise (?id ?message ?topic ?item ?data)
  (bind ?inst (instance-table-get-instance ?id))
  (if (neq ?inst "") then
    (return (bool-to-long (send ?inst on-stop-advise ?topic ?item)))
  )
  (return 1)
)

(defmessage-handler MAIN::wxConnection add-event-handlers primary ()

  (call-next-handler)
  (window-add-callback ?self:id OnAdvise      gui-connection-on-advise)
  (window-add-callback ?self:id OnExecute     gui-connection-on-execute)
  (window-add-callback ?self:id OnPoke        gui-connection-on-poke)
  (window-add-callback ?self:id OnRequest     gui-connection-on-request)
  (window-add-callback ?self:id OnStartAdvise gui-connection-on-start-advise)
  (window-add-callback ?self:id OnStopAdvise  gui-connection-on-stop-advise)
)

