;;; ======================================================================
;;; wx_grid.clp
;;; ======================================================================

(defclass MAIN::wxGrid (is-a wxPanel)
    (role concrete)
    
    (slot nb-rows
        (create-accessor read-write)
;        (access initialize-only)
        (visibility public)
        (default 0))
        
    (slot nb-cols
        (create-accessor read-write)
;        (access initialize-only)
        (visibility public)
        (default 0))
)

;;; ======================================================================
;;; DEFMESSAGE-HANDLERS
;;; ======================================================================

(defmessage-handler MAIN::wxGrid create ()

    (send ?self win-init)
    
    ;; creates the grid
    
    (bind ?parent-id 0)
    (if (neq ?self:parent nil) then (bind ?parent-id (send ?self:parent get-id)))

    (bind ?self:id 
        (grid-create ?parent-id
                     ?self:x
                     ?self:y
                     ?self:width
                     ?self:height
                     ?self:style
                     ?self:window-name))
    (grid-create-grid ?self:id ?self:nb-rows ?self:nb-cols)
    
    (if (> ?self:id 0) then
        (send ?self update-dimensions)
        (send ?self adjust-scrollbars)
        (bind ?self:dc (make-instance (gensym) of wxCanvasDC (id (canvas-get-dc ?self:id))))
        (instance-table-add-entry ?self:id (instance-name ?self))
        (send ?self add-event-handlers)
    )
)

(defmessage-handler MAIN::wxGrid adjust-scrollbars ()
    (return (grid-adjust-scrollbars ?self:id))
)

(defmessage-handler MAIN::wxGrid append-cols (?n ?update-labels)
    (bind ?ok (long-to-bool (grid-append-cols ?self:id ?n ?update-labels))) 
    (if (eq ?ok TRUE) then
        (send ?self adjust-scrollbars)
        (send ?self update-dimensions)
        (bind ?self:nb-cols (+ ?self:nb-cols ?n))
    )
    (return ?ok)
)

(defmessage-handler MAIN::wxGrid append-rows (?n ?update-labels)
    (bind ?ok (long-to-bool (grid-append-rows ?self:id ?n ?update-labels))) 
    (if (eq ?ok TRUE) then
        (send ?self adjust-scrollbars)
        (send ?self update-dimensions)
        (bind ?self:nb-rows (+ ?self:nb-rows ?n))
    )
    (return ?ok)
)

(defmessage-handler MAIN::wxGrid clear-grid ()
    (return (long-to-bool (grid-clear-grid ?self:id)))
)

(defmessage-handler MAIN::wxGrid delete-cols (?position ?n ?update-labels)
    (bind ?ok (long-to-bool (grid-delete-cols ?self:id
                                              ?position
                                              ?n
                                              ?update-labels)))
    (if (eq ?ok TRUE) then
        (send ?self adjust-scrollbars)
        (send ?self update-dimensions)
        (bind ?self:nb-cols (- ?self:nb-cols ?n))
    )
    (return ?ok)
)

(defmessage-handler MAIN::wxGrid delete-rows (?position ?n ?update-labels)
    (bind ?ok (long-to-bool (grid-delete-rows ?self:id
                                              ?position
                                              ?n
                                              ?update-labels)))
    (if (eq ?ok TRUE) then
        (send ?self adjust-scrollbars)
        (send ?self update-dimensions)
        (bind ?self:nb-rows (- ?self:nb-rows ?n))
    )
    (return ?ok)
)

(defmessage-handler MAIN::wxGrid get-cell-alignment (?row ?col)
    (return (grid-get-cell-alignment ?self:id ?row ?col))
)

(defmessage-handler MAIN::wxGrid get-cell-background-colour (?row ?col)
    (return (grid-get-cell-background-colour ?self:id ?row ?col))
)

(defmessage-handler MAIN::wxGrid get-cell-bitmap (?row ?col)
    (return (grid-get-cell-bitmap ?self:id ?row ?col))
)

(defmessage-handler MAIN::wxGrid get-cell-text-colour (?row ?col)
    (return (grid-get-cell-text-colour ?self:id ?row ?col))
)

(defmessage-handler MAIN::wxGrid get-cell-value (?row ?col)
    (bind ?r (grid-get-cell-value ?self:id ?row ?col))
    (return ?r)
)

(defmessage-handler MAIN::wxGrid get-column-width (?col)
    (return (grid-get-column-width ?self:id ?col))
)

(defmessage-handler MAIN::wxGrid get-cursor-column ()
    (return (grid-get-cursor-column ?self:id))
)

(defmessage-handler MAIN::wxGrid get-cursor-row ()
    (return (grid-get-cursor-row ?self:id))
)

(defmessage-handler MAIN::wxGrid get-rows ()
    (return (grid-get-rows ?self:id))
)

(defmessage-handler MAIN::wxGrid get-cols ()
    (return (grid-get-cols ?self:id))
)

(defmessage-handler MAIN::wxGrid get-editable ()
    (return (long-to-bool (grid-get-editable ?self:id)))
)

(defmessage-handler MAIN::wxGrid get-label-alignment (?orientation)
    (return (grid-get-label-alignment ?self:id ?orientation))
)

(defmessage-handler MAIN::wxGrid get-label-background-colour ()
    (return (grid-get-label-background-colour ?self:id))
)

(defmessage-handler MAIN::wxGrid get-label-size (?orientation)
    (return (grid-get-label-size ?self:id ?orientation))
)

(defmessage-handler MAIN::wxGrid get-label-text-colour ()
    (return (grid-get-label-text-colour ?self:id))
)

(defmessage-handler MAIN::wxGrid get-label-value (?orientation ?position)
    (return (grid-get-label-value ?self:id ?orientation ?position))
)

(defmessage-handler MAIN::wxGrid get-row-height (?row)
    (return (grid-get-row-height ?self:id ?row))
)

(defmessage-handler MAIN::wxGrid get-scroll-pos-x ()
    (return (grid-get-scroll-pos-x ?self:id))
)

(defmessage-handler MAIN::wxGrid get-scroll-pos-y ()
    (return (grid-get-scroll-pos-y ?self:id))
)

(defmessage-handler MAIN::wxGrid get-text-item ()
    (return (grid-get-text-item ?self:id))
)

(defmessage-handler MAIN::wxGrid insert-cols (?position ?n ?update-labels)
    (bind ?ok (long-to-bool (grid-insert-cols ?self:id
                                              ?position
                                              ?n
                                              ?update-labels)))
    (if (eq ?ok TRUE) then
        (send ?self adjust-scrollbars)
        (send ?self update-dimensions)
        (bind ?self:nb-cols (+ ?self:nb-cols ?n))
    )
)

(defmessage-handler MAIN::wxGrid insert-rows (?position ?n ?update-labels)
    (bind ?ok (long-to-bool (grid-insert-rows
                                ?self:id
                                ?position
                                ?n
                                ?update-labels)))
    (if (eq ?ok TRUE) then
        (send ?self adjust-scrollbars)
        (send ?self update-dimensions)
        (bind ?self:nb-rows (+ ?self:nb-rows ?n))
    )
)

(defmessage-handler MAIN::wxGrid on-activate (?flag)
    (return (grid-on-activate ?self:id ?flag))
)

(defmessage-handler MAIN::wxGrid on-cell-right-click primary (?row ?col ?x ?y ?ctrl ?shft)
)

(defmessage-handler MAIN::wxGrid on-cell-left-click primary (?row ?col ?x ?y ?ctrl ?shft)
)

(defmessage-handler MAIN::wxGrid on-cell-change primary (?row ?col)
)

(defmessage-handler MAIN::wxGrid on-change-labels primary ()
)

(defmessage-handler MAIN::wxGrid on-change-selection-label primary ()
)

(defmessage-handler MAIN::wxGrid on-paint ()
    (return (grid-on-paint ?self:id))
)

(defmessage-handler MAIN::wxGrid on-size (?w ?h)
    (return (grid-on-size ?self:id ?w ?h))
)

(defmessage-handler MAIN::wxGrid set-cell-alignment (?alignment ?row ?col)
    (return (grid-set-cell-alignment ?self:id ?alignment ?row ?col))
)

(defmessage-handler MAIN::wxGrid set-cell-background-colour (?colour ?row ?col)
    (return (grid-set-cell-background-colour ?self:id ?colour ?row ?col))
)

(defmessage-handler MAIN::wxGrid set-cell-bitmap (?bitmap ?row ?col)
    (if (eq ?bitmap 0) then
        (bind ?bmp-id 0)
    else
        (bind ?bmp-id (send ?bitmap get-id))
    )
    (bind ?ok (grid-set-cell-bitmap ?self:id ?bmp-id ?row ?col))
;    (send ?self refresh)
    (return ?ok)
)

(defmessage-handler MAIN::wxGrid set-cell-text-colour (?colour ?row ?col)
    (return (grid-set-cell-text-colour ?self:id ?colour ?row ?col))
)

(defmessage-handler MAIN::wxGrid set-cell-text-font (?font ?row ?col)
    (return (grid-set-cell-text-font ?self:id ?font ?row ?col))
)

(defmessage-handler MAIN::wxGrid set-cell-value (?value ?row ?col)
    (bind ?r (grid-set-cell-value ?self:id ?value ?row ?col))
;    (send ?self refresh)
    (return ?r)
)

(defmessage-handler MAIN::wxGrid set-column-width (?col ?width)
    (grid-set-column-width ?self:id ?col ?width)
    (send ?self update-dimensions)
    (send ?self adjust-scrollbars)
)

(defmessage-handler MAIN::wxGrid set-divider-pen (?pen)
    (return (grid-set-divider-pen ?self:id ?pen))
)

(defmessage-handler MAIN::wxGrid set-editable (?editable)
    (return (grid-set-editable ?self:id ?editable))
)

(defmessage-handler MAIN::wxGrid set-grid-cursor (?row ?col)
    (return (grid-set-grid-cursor ?self:id ?row ?col))
)

(defmessage-handler MAIN::wxGrid set-label-alignment (?orientation ?alignment)
    (return (grid-set-label-alignment ?self:id ?orientation ?alignment))
)

(defmessage-handler MAIN::wxGrid set-label-background-colour (?colour)
    (return (grid-set-label-background-colour ?self:id ?colour))
)

(defmessage-handler MAIN::wxGrid set-label-size (?orientation ?size)
    (return (grid-set-label-size ?self:id ?orientation ?size))
)

(defmessage-handler MAIN::wxGrid set-label-text-colour (?colour)
    (return (grid-set-label-text-colour ?self:id ?colour))
)

(defmessage-handler MAIN::wxGrid set-label-text-font (?font)
    (return (grid-set-label-text-font ?self:id ?font))
)

(defmessage-handler MAIN::wxGrid set-label-value (?orientation ?value ?position)
    (return (grid-set-label-value ?self:id ?orientation ?value ?position))
)

(defmessage-handler MAIN::wxGrid set-row-height (?row ?height)
    (grid-set-row-height ?self:id ?row ?height)
    (send ?self update-dimensions)
    (send ?self adjust-scrollbars)
)

(defmessage-handler MAIN::wxGrid update-dimensions ()
    (return (grid-update-dimensions ?self:id))
)

;;; OnCellRightClick callback
(deffunction gui-grid-on-cell-right-click (?id ?row ?col ?x ?y
                                           ?ctrl ?shft)
    (bind ?inst (instance-table-get-instance ?id))
    (if (neq ?inst "") then
        (send (send ?inst get-event-handler) on-cell-right-click
                                               ?row ?col ?x ?y
                                               ?ctrl ?shft)
    )
)

;;; OnCellLeftClick callback
(deffunction gui-grid-on-cell-left-click (?id ?row ?col ?x ?y
                                           ?ctrl ?shft)
    (bind ?inst (instance-table-get-instance ?id))
    (if (neq ?inst "") then
        (send (send ?inst get-event-handler) on-cell-left-click
                                               ?row ?col ?x ?y
                                               ?ctrl ?shft)
    )
)

;;; OnCellChange callback
(deffunction gui-grid-on-cell-change (?id ?row ?col)
    (bind ?inst (instance-table-get-instance ?id))
    (if (neq ?inst "") then
        (send (send ?inst get-event-handler) on-cell-change ?row ?col)
    )
)

;;; OnChangeLabels callback
(deffunction gui-grid-on-change-labels (?id)
    (bind ?inst (instance-table-get-instance ?id))
    (if (neq ?inst "") then
        (send (send ?inst get-event-handler) on-change-labels)
    )
)

;;; OnChangeSelectionLabel callback
(deffunction gui-grid-on-change-selection-label (?id)
    (bind ?inst (instance-table-get-instance ?id))
    (if (neq ?inst "") then
        (send (send ?inst get-event-handler) on-change-selection-label)
    )
)

(defmessage-handler MAIN::wxGrid add-event-handlers primary ()
  (call-next-handler)
  (window-add-callback ?self:id OnCellRightClick gui-grid-on-cell-right-click)
  (window-add-callback ?self:id OnCellLeftClick  gui-grid-on-cell-left-click)
  (window-add-callback ?self:id OnCellChange     gui-grid-on-cell-change)
  (window-add-callback ?self:id OnChangeLabels   gui-grid-on-change-labels)
  (window-add-callback ?self:id OnChangeSelectionLabel gui-grid-on-change-selection-label)
)