;;; ======================================================================
;;; wx_clp.clp
;;; GDI objects, e.g. pen, brush, bitmap etc.
;;; ======================================================================

(defclass MAIN::wxBitmap (is-a wxObject)
  (role concrete)
  (slot filename
    (create-accessor read-write)
    (visibility public)
    (type STRING)
    (default ""))
  (slot bitmap-type
    (create-accessor read-write)
    (visibility public)
    (default wxBITMAP_TYPE_BMP))
  (slot width
    (create-accessor write)
    (visibility public)
    (type INTEGER)
    (default 0))
  (slot height
    (create-accessor write)
    (visibility public)
    (type INTEGER)
    (default 0))
  (slot depth
    (create-accessor write)
    (visibility public)
    (type INTEGER)
    (default -1))
 )

(defclass MAIN::wxIcon (is-a wxBitmap)
  (role concrete)
 )

(defclass MAIN::wxCursor (is-a wxBitmap)
  (role concrete)

  (slot cursor-name
    (create-accessor read-write)
    (visibility public)
    (default nil))
  (slot x
    (create-accessor read-write)
    (visibility public)
    (type INTEGER)
    (default 0))
  (slot y
    (create-accessor read-write)
    (visibility public)
    (type INTEGER)
    (default 0))
 )

(defclass MAIN::wxPen (is-a wxObject)
  (role concrete)
  (slot width
    (create-accessor read-write)
    (visibility public)
    (type INTEGER)
    (default 1))
  (slot style
    (create-accessor read-write)
    (visibility public)
    (type SYMBOL)
    (default wxSOLID))
  (slot colour
    (create-accessor read-write)
    (visibility public)
    (type STRING)
    (default "BLACK"))
 )

(defclass MAIN::wxBrush (is-a wxObject)
  (role concrete)
  (slot style
    (create-accessor read-write)
    (visibility public)
    (type SYMBOL)
    (default wxSOLID))
  (slot colour
    (create-accessor read-write)
    (visibility public)
    (type STRING)
    (default "WHITE"))
 )

(defclass MAIN::wxFont (is-a wxObject)
  (role concrete)
  (slot point-size
    (create-accessor write)
    (visibility public)
    (type INTEGER)
    (default 10))
  (slot family
    (create-accessor write)
    (visibility public)
    (type SYMBOL)
    (default wxSWISS))
  (slot style
    (create-accessor write)
    (visibility public)
    (type SYMBOL)
    (default wxNORMAL))
  (slot weight
    (create-accessor write)
    (visibility public)
    (type SYMBOL)
    (default wxNORMAL))
  (slot underlined
    (create-accessor write)
    (visibility public)
    (type SYMBOL)
    (default FALSE))
 )

;;; ======================================================================
;;; DEFMESSAGE-HANDLERS for wxBitmap
;;; ======================================================================

(defmessage-handler MAIN::wxBitmap create ()
  ;; Create the bitmap, by filename or width/height/depth method
  (if (neq ?self:filename "") then
  
   (bind ?self:id
      (bitmap-load-from-file
                	?self:filename
                	?self:bitmap-type
     ))
   else
   (bind ?self:id
      (bitmap-create	?self:width
                        ?self:height
			?self:depth
     ))
  )
  (instance-table-add-entry ?self:id (instance-name ?self))
  (send ?self add-event-handlers)
)

(defmessage-handler MAIN::wxBitmap delete before ()
  (if (and (neq ?self:pending-delete TRUE)
           (eq 1 (wxclips-object-exists ?self:id))
      )
    then
    (instance-table-delete-entry ?self:id)
    (dynamic-put pending-delete TRUE)
    (bitmap-delete ?self:id)
  )
  (return TRUE)
)

(defmessage-handler MAIN::wxBitmap get-width primary ()
  (if (valid-id ?self:id) then (dynamic-put width (bitmap-get-width ?self:id)))
  (return ?self:width)
)

(defmessage-handler MAIN::wxBitmap get-height primary ()
  (if (valid-id ?self:id) then (dynamic-put height (bitmap-get-height ?self:id)))
  (return ?self:height)
)

(defmessage-handler MAIN::wxBitmap get-depth primary ()
  (return ?self:depth)
)

;;; ======================================================================
;;; DEFMESSAGE-HANDLERS for wxIcon
;;; ======================================================================

(defmessage-handler MAIN::wxIcon create ()
  ;; Create the icon, by filename or width/height/depth method
  (if (neq ?self:filename "") then
  
   (bind ?self:id
      (icon-load-from-file
                	?self:filename
                	?self:bitmap-type
     )))
  (instance-table-add-entry ?self:id (instance-name ?self))
  (send ?self add-event-handlers)
)

(defmessage-handler MAIN::wxIcon delete before ()
  (if (and (neq ?self:pending-delete TRUE)
           (eq 1 (wxclips-object-exists ?self:id))
      )
    then
    (instance-table-delete-entry ?self:id)
    (dynamic-put pending-delete TRUE)
    (icon-delete ?self:id)
  )
  (return TRUE)
)

;;; ======================================================================
;;; DEFMESSAGE-HANDLERS for wxPen
;;; ======================================================================

(defmessage-handler MAIN::wxPen create ()
   (bind ?self:id (pen-create ?self:colour ?self:width ?self:style))
  (instance-table-add-entry ?self:id (instance-name ?self))
  (send ?self add-event-handlers)
)

(defmessage-handler MAIN::wxPen delete before ()
  (if (and (neq ?self:pending-delete TRUE)
           (eq 1 (wxclips-object-exists ?self:id))
      )
    then
    (instance-table-delete-entry ?self:id)
    (dynamic-put pending-delete TRUE)
    (pen-delete ?self:id)
  )
  (return TRUE)
)


;;; ======================================================================
;;; DEFMESSAGE-HANDLERS for wxBrush
;;; ======================================================================

(defmessage-handler MAIN::wxBrush create ()
   (bind ?self:id (brush-create ?self:colour ?self:style))
  (instance-table-add-entry ?self:id (instance-name ?self))
  (send ?self add-event-handlers)
)

(defmessage-handler MAIN::wxBrush delete before ()
  (if (and (neq ?self:pending-delete TRUE)
           (eq 1 (wxclips-object-exists ?self:id))
      )
    then
    (instance-table-delete-entry ?self:id)
    (dynamic-put pending-delete TRUE)
    (brush-delete ?self:id)
  )
  (return TRUE)
)

;;; ======================================================================
;;; DEFMESSAGE-HANDLERS for wxCursor
;;; ======================================================================

(defmessage-handler MAIN::wxCursor create ()
  ;; Create the bitmap, by filename or stock cursor method
  (if (neq ?self:filename "") then
  
   (bind ?self:id
      (cursor-load-from-file
                	?self:filename
                	?self:bitmap-type
                	?self:x
                	?self:y
     ))
   else
   (bind ?self:id
      (cursor-create	?self:cursor-name
     ))
  )
  (instance-table-add-entry ?self:id (instance-name ?self))
  (send ?self add-event-handlers)
)

(defmessage-handler MAIN::wxCursor delete before ()
  (if (and (neq ?self:pending-delete TRUE)
           (eq 1 (wxclips-object-exists ?self:id))
      )
    then
    (instance-table-delete-entry ?self:id)
    (dynamic-put pending-delete TRUE)
    (cursor-delete ?self:id)
  )
  (return TRUE)
)

;;; ======================================================================
;;; DEFMESSAGE-HANDLERS for wxFont
;;; ======================================================================

(defmessage-handler MAIN::wxFont create ()
  (bind ?self:id (font-create ?self:point-size ?self:family ?self:style ?self:weight (bool-to-long ?self:underlined)))
  (instance-table-add-entry ?self:id (instance-name ?self))
  (send ?self add-event-handlers)
)

(defmessage-handler MAIN::wxFont delete before ()
  (if (and (neq ?self:pending-delete TRUE)
           (eq 1 (wxclips-object-exists ?self:id))
      )
    then
    (instance-table-delete-entry ?self:id)
    (dynamic-put pending-delete TRUE)
    (font-delete ?self:id)
  )
  (return TRUE)
)

(defmessage-handler MAIN::wxFont get-point-size primary ()
  (return ?self:point-size)
)

(defmessage-handler MAIN::wxFont get-family primary ()
  (return ?self:family)
)

(defmessage-handler MAIN::wxFont get-style primary ()
  (return ?self:style)
)

(defmessage-handler MAIN::wxFont get-weight primary ()
  (return ?self:weight)
)

(defmessage-handler MAIN::wxFont get-underlined primary ()
  (return ?self:underlined)
)

