;;; ======================================================================
;;; wx_frame.clp
;;; ======================================================================

(defclass MAIN::wxFrame (is-a wxWindow)
  (role concrete)
  (slot style
    (create-accessor read-write)
    (access initialize-only)
    (visibility public)
    (default "wxDEFAULT_FRAME"))
 )

(defmessage-handler MAIN::wxFrame create ()
;  (printout t "*** wxFrame create" crlf)

        (send ?self win-init)

	;; Create the frame.
        (bind ?parent-id 0)

        (if (integerp ?self:parent) then (bind ?parent-id ?self:parent) else
         (if (neq ?self:parent nil) then (bind ?parent-id (send ?self:parent get-id))))
         
	(bind ?self:id
		(frame-create	?parent-id
				?self:title
				?self:x
				?self:y
				?self:width
				?self:height
				?self:style
				?self:window-name
                ))
        (instance-table-add-entry ?self:id (instance-name ?self))
        (send ?self add-event-handlers)
)

(defmessage-handler MAIN::wxFrame create-status-line primary ($?n)
  (bind ?which 0)
  (if (neq (nth$ 1 ?n) nil) then (bind ?which (nth$ 1 ?n)))
  (return (long-to-bool (frame-create-status-line ?self:id ?which)))
)

(defmessage-handler MAIN::wxFrame set-status-text primary (?text $?n)
  (bind ?which 0)
  (if (neq (nth$ 1 ?n) nil) then (bind ?which (nth$ 1 ?n)))
  (return (long-to-bool (frame-set-status-text ?self:id ?text ?which)))
)

(defmessage-handler MAIN::wxFrame on-size primary (?w ?h)
  (frame-on-size ?self:id ?w ?h)
)

(defmessage-handler MAIN::wxFrame iconize primary (?flag)
  (return (long-to-bool (frame-iconize ?self:id ?flag)))
)

(defmessage-handler MAIN::wxFrame set-icon primary (?icon)
  (return (long-to-bool (frame-set-icon ?self:id (send ?icon get-id))))
)

(defmessage-handler MAIN::wxFrame set-title primary (?title)
  (return (long-to-bool (frame-set-title ?self:id ?title)))
)

(defmessage-handler MAIN::wxFrame set-tool-bar primary (?toolbar)
  (return (long-to-bool (frame-set-tool-bar ?self:id (send ?toolbar get-id))))
)

(defmessage-handler MAIN::wxFrame set-menu-bar primary (?menu-bar)
  (return (long-to-bool (frame-set-menu-bar ?self:id (send ?menu-bar get-id))))
)


;;; OnActivate callback
(deffunction gui-frame-on-activate (?id ?flag)
  (bind ?inst (instance-table-get-instance ?id))
  (if (neq ?inst "") then (send (send ?inst get-event-handler) on-activate (long-to-bool ?flag)))
 )

;;; OnMenuCommand callback
(deffunction gui-frame-on-menu-command (?id ?item-id)
  (bind ?inst (instance-table-get-instance ?id))
  (if (neq ?inst "") then (send (send ?inst get-event-handler) on-menu-command ?item-id))
 )

;;; OnMenuSelect callback
(deffunction gui-frame-on-menu-select (?id ?item-id)
  (bind ?inst (instance-table-get-instance ?id))
  (if (neq ?inst "") then (send (send ?inst get-event-handler) on-menu-select ?item-id))
 )

(defmessage-handler MAIN::wxFrame add-event-handlers primary ()
  (call-next-handler)

  (window-add-callback ?self:id OnActivate      gui-frame-on-activate)
  (window-add-callback ?self:id OnMenuCommand   gui-frame-on-menu-command)
  (window-add-callback ?self:id OnMenuSelect    gui-frame-on-menu-select)
)

