;;; ======================================================================
;;; wx_evt.clp
;;; Event handler class: base class for wxWindow
;;; ======================================================================

;;; As in wxWindows, wxCOOL uses a 'pluggable' event handler for
;;; directing events to convenient objects (by default, the window
;;; originating the event).
;;; NOTE that not all of these handlers are called by wxCLIPS: some have yet
;;; to be implemented.

(defclass MAIN::wxEvtHandler (is-a wxObject)
  (role abstract)
  (slot client-data
    (create-accessor read-write)
    (visibility public)
    (default nil))
 )

;;; ======================================================================
;;; DEFMESSAGE-HANDLERS
;;; ======================================================================

(defmessage-handler MAIN::wxEvtHandler on-size primary (?width ?height)
)

(defmessage-handler MAIN::wxEvtHandler on-move primary (?x ?y)
)

(defmessage-handler MAIN::wxEvtHandler on-event primary (?event)
)

(defmessage-handler MAIN::wxEvtHandler on-command primary (?win ?event)
)

(defmessage-handler MAIN::wxEvtHandler on-scroll primary (?event)
)

(defmessage-handler MAIN::wxEvtHandler on-char primary (?event)
)

(defmessage-handler MAIN::wxEvtHandler on-paint primary ()
)

(defmessage-handler MAIN::wxEvtHandler on-close primary ()
  (return FALSE)
)

(defmessage-handler MAIN::wxEvtHandler on-activate primary (?flag)
)

(defmessage-handler MAIN::wxEvtHandler on-menu-command primary (?id)
)

(defmessage-handler MAIN::wxEvtHandler on-menu-select primary (?id)
)

(defmessage-handler MAIN::wxEvtHandler on-set-focus primary ()
)

(defmessage-handler MAIN::wxEvtHandler on-kill-focus primary ()
)

(defmessage-handler MAIN::wxEvtHandler on-drop-files primary ()
)

(defmessage-handler MAIN::wxEvtHandler on-default-action primary (?item)
)

(defmessage-handler MAIN::wxEvtHandler on-change-focus (?from ?to)
)


