;;; ======================================================================
;;; wx_event.clp
;;; ======================================================================

;;; CLASSES

(defclass MAIN::wxEvent (is-a wxObject)
	(role abstract)
	(slot id
         (create-accessor read-write)
         (visibility public)
         (type INTEGER)
         (default 0))
)

(defclass MAIN::wxMouseEvent (is-a wxEvent)
	(role concrete)
)

(defclass MAIN::wxKeyEvent (is-a wxEvent)
	(role concrete)
	(slot keycode
         (create-accessor read-write)
         (visibility public)
         (type INTEGER)
         (default 0))
)

(defclass MAIN::wxCommandEvent (is-a wxEvent)
	(role concrete)
)

;;; ======================================================================
;;; DEFMESSAGE-HANDLERS
;;; ======================================================================

(defmessage-handler MAIN::wxEvent get-event-type ()
  (return (event-get-event-type ?self:id))
)

(defmessage-handler MAIN::wxMouseEvent button (?button)
  (return (long-to-bool (mouse-event-button ?self:id ?button)))
)

(defmessage-handler MAIN::wxMouseEvent button-down ()
  (return (long-to-bool (mouse-event-button-down ?self:id)))
)

(defmessage-handler MAIN::wxMouseEvent control-down ()
  (return (long-to-bool (mouse-event-control-down ?self:id)))
)

(defmessage-handler MAIN::wxMouseEvent dragging ()
  (return (long-to-bool (mouse-event-dragging ?self:id)))
)

(defmessage-handler MAIN::wxMouseEvent left-down ()
  (return (long-to-bool (mouse-event-left-down ?self:id)))
)

(defmessage-handler MAIN::wxMouseEvent left-up ()
  (return (long-to-bool (mouse-event-left-up ?self:id)))
)

(defmessage-handler MAIN::wxMouseEvent is-button ()
  (return (long-to-bool (mouse-event-is-button ?self:id)))
)

(defmessage-handler MAIN::wxMouseEvent middle-down ()
  (return (long-to-bool (mouse-event-middle-down ?self:id)))
)

(defmessage-handler MAIN::wxMouseEvent middle-up ()
  (return (long-to-bool (mouse-event-middle-up ?self:id)))
)

(defmessage-handler MAIN::wxMouseEvent position-x ()
  (return (mouse-event-position-x ?self:id))
)

(defmessage-handler MAIN::wxMouseEvent position-y ()
  (return (mouse-event-position-y ?self:id))
)

(defmessage-handler MAIN::wxMouseEvent right-up ()
  (return (long-to-bool (mouse-event-right-up ?self:id)))
)

(defmessage-handler MAIN::wxMouseEvent right-down ()
  (return (long-to-bool (mouse-event-right-down ?self:id)))
)

(defmessage-handler MAIN::wxMouseEvent shift-down ()
  (return (long-to-bool (mouse-event-shift-down ?self:id)))
)

(defmessage-handler MAIN::wxCommandEvent get-selection ()
  (return (command-event-get-selection ?self:id))
)

(defmessage-handler MAIN::wxCommandEvent is-selection ()
  (return (long-to-bool (command-event-is-selection ?self:id)))
)


