;;; ======================================================================
;;; wx_dialg.clp
;;; ======================================================================

(defclass MAIN::wxDialogBox (is-a wxPanel)
  (role concrete)
  (slot modal
    (create-accessor read-write)
    (access initialize-only)
    (visibility public)
    (type SYMBOL)
    (default FALSE))
  (slot style
    (create-accessor read-write)
    (access initialize-only)
    (visibility public)
    (default "wxDEFAULT_DIALOG_STYLE"))
 )

(defmessage-handler MAIN::wxDialogBox create ()

        (send ?self win-init)

	;; Create the dialog.
        (bind ?parent-id 0)
        (if (integerp ?self:parent) then (bind ?parent-id ?self:parent) else
          (if (neq ?self:parent nil) then (bind ?parent-id (send ?self:parent get-id))))

        (if (neq (send ?self get-resource) "") then
          (bind ?self:id (dialog-box-create-from-resource ?parent-id (send ?self get-resource)))
          (send ?self create-child-objects)
         else
  	  (bind ?self:id
		(dialog-box-create ?parent-id
				?self:title
				(bool-to-long ?self:modal)
				?self:x
				?self:y
				?self:width
				?self:height
				?self:style
				?self:window-name
                ))
        )
        (if (> ?self:id 0) then
          (bind ?self:dc (make-instance (gensym) of wxCanvasDC (id (canvas-get-dc ?self:id))))
          (instance-table-add-entry ?self:id (instance-name ?self))
          (send ?self add-event-handlers)
        )
)

