;;; ======================================================================
;;; wx_dc.clp
;;; Device contexts
;;; ======================================================================

;;; ======================================================================
;;; CLASS wxDC
;;; ======================================================================

(defclass MAIN::wxDC (is-a wxObject)
  (role abstract)
 )

;;; ======================================================================
;;; CLASS wxCanvasDC
;;; ======================================================================

(defclass MAIN::wxCanvasDC (is-a wxDC)
  (role concrete)
 )

;;; ======================================================================
;;; CLASS wxMemoryDC
;;; ======================================================================

(defclass MAIN::wxMemoryDC (is-a wxCanvasDC)
  (role concrete)
 )

;;; ======================================================================
;;; CLASS wxPrinterDC
;;; ======================================================================

(defclass MAIN::wxPrinterDC (is-a wxDC)
  (role concrete)
  (slot filename
    (create-accessor read-write)
    (visibility public)
    (type STRING)
    (default ""))
  (slot driver
    (create-accessor read-write)
    (visibility public)
    (type STRING)
    (default ""))
  (slot device
    (create-accessor read-write)
    (visibility public)
    (type STRING)
    (default ""))
  (slot interactive
    (create-accessor read-write)
    (visibility public)
    (type SYMBOL)
    (default FALSE))
  (slot window
    (create-accessor read-write)
    (visibility public)
    (default nil))
 )

;;; ======================================================================
;;; CLASS wxPostScriptDC
;;; ======================================================================

(defclass MAIN::wxPostScriptDC (is-a wxDC)
  (role concrete)
  (slot filename
    (create-accessor read-write)
    (visibility public)
    (type STRING)
    (default ""))
  (slot interactive
    (create-accessor read-write)
    (visibility public)
    (type SYMBOL)
    (default FALSE))
  (slot window
    (create-accessor read-write)
    (visibility public)
    (default nil))
 )

;;; ======================================================================
;;; CLASS wxMetaFileDC
;;; ======================================================================

(defclass MAIN::wxMetaFileDC (is-a wxDC)
  (role concrete)
  (slot filename
    (create-accessor read-write)
    (visibility public)
    (type STRING)
    (default ""))
  
 )

;;; ======================================================================
;;; DEFMESSAGE-HANDLERS for wxDC
;;; ======================================================================

(defmessage-handler MAIN::wxDC create ()
  (instance-table-add-entry ?self:id (instance-name ?self))
  (send ?self add-event-handlers)
)

(defmessage-handler MAIN::wxDC delete before ()
  (if (and (neq ?self:pending-delete TRUE)
           (eq 1 (wxclips-object-exists ?self:id))
      )
    then
    (dynamic-put pending-delete TRUE)
    (instance-table-delete-entry ?self:id)
    (if (neq (class ?self) wxCanvasDC) then
      (dc-delete ?self:id)
    )
  )
  (return TRUE)
)

(defmessage-handler MAIN::wxDC begin-drawing ()
  (long-to-bool (dc-begin-drawing ?self:id))
)

(defmessage-handler MAIN::wxDC blit (?dest-x ?dest-y ?width ?height ?source-dc
   ?source-x ?source-y ?logical-op)
  (long-to-bool (dc-blit ?self:id ?dest-x ?dest-y ?width ?height (send ?source-dc get-id)
    ?source-x ?source-y ?logical-op))
)

(defmessage-handler MAIN::wxDC clear ()
  (long-to-bool (dc-clear ?self:id))
)

(defmessage-handler MAIN::wxDC destroy-clipping-region ()
  (long-to-bool (dc-destroy-clipping-region ?self:id))
)

(defmessage-handler MAIN::wxDC draw-ellipse (?x ?y ?width ?height)
  (long-to-bool (dc-draw-ellipse ?self:id ?x ?y ?width ?height))
)

(defmessage-handler MAIN::wxDC draw-line (?x1 ?y1 ?x2 ?y2)
  (long-to-bool (dc-draw-line ?self:id ?x1 ?y1 ?x2 ?y2))
)

(defmessage-handler MAIN::wxDC draw-lines (?multivalue)
  (long-to-bool (dc-draw-lines ?self:id ?multivalue))
)

(defmessage-handler MAIN::wxDC draw-point (?x ?y)
  (long-to-bool (dc-draw-point ?self:id ?x ?y))
)

(defmessage-handler MAIN::wxDC draw-polygon (?multivalue)
  (long-to-bool (dc-draw-polygon ?self:id ?multivalue))
)

(defmessage-handler MAIN::wxDC draw-rectangle (?x ?y ?width ?height)
  (long-to-bool (dc-draw-rectangle ?self:id ?x ?y ?width ?height))
)

(defmessage-handler MAIN::wxDC draw-rounded-rectangle (?x ?y ?width ?height ?radius)
  (long-to-bool (dc-draw-rounded-rectangle ?self:id ?x ?y ?width ?height ?radius))
)

(defmessage-handler MAIN::wxDC draw-text (?text ?x ?y)
  (long-to-bool (dc-draw-text ?self:id ?text ?x ?y))
)

(defmessage-handler MAIN::wxDC draw-spline (?multivalue)
  (long-to-bool (dc-draw-spline ?self:id ?multivalue))
)

(defmessage-handler MAIN::wxDC end-doc ()
  (long-to-bool (dc-end-doc ?self:id))
)

(defmessage-handler MAIN::wxDC end-drawing ()
  (long-to-bool (dc-end-drawing ?self:id))
)

(defmessage-handler MAIN::wxDC end-page ()
  (long-to-bool (dc-end-page ?self:id))
)

(defmessage-handler MAIN::wxDC get-min-x ()
  (return (dc-get-min-x ?self:id))
)

(defmessage-handler MAIN::wxDC get-min-y ()
  (return (dc-get-min-y ?self:id))
)

(defmessage-handler MAIN::wxDC get-max-x ()
  (return (dc-get-max-x ?self:id))
)

(defmessage-handler MAIN::wxDC get-max-y ()
  (return (dc-get-max-y ?self:id))
)

(defmessage-handler MAIN::wxDC get-text-extent-height (?text)
  (return (dc-get-text-extent-height ?self:id ?text))
)

(defmessage-handler MAIN::wxDC get-text-extent-width (?text)
  (return (dc-get-text-extent-width ?self:id ?text))
)

(defmessage-handler MAIN::wxDC ok (?text)
  (return (long-to-bool (dc-ok ?self:id)))
)

(defmessage-handler MAIN::wxDC start-doc (?msg)
  (return (long-to-bool (dc-start-doc ?self:id ?msg)))
)

(defmessage-handler MAIN::wxDC start-page ()
  (return (long-to-bool (dc-start-page ?self:id)))
)

(defmessage-handler MAIN::wxDC set-brush (?brush)
  (if (eq ?brush nil) then
    (return (long-to-bool (dc-set-brush ?self:id 0)))
  else
   (return (long-to-bool (dc-set-brush ?self:id (send ?brush get-id)))))
)

(defmessage-handler MAIN::wxDC set-background (?brush)
  (if (eq ?brush nil) then
    (return (long-to-bool (dc-set-background ?self:id 0)))
  else
   (return (long-to-bool (dc-set-background ?self:id (send ?brush get-id)))))
)

(defmessage-handler MAIN::wxDC set-background-mode (?mode)
  (return (long-to-bool (dc-set-background ?self:id ?mode)))
)

(defmessage-handler MAIN::wxDC set-colourmap (?colourmap)
  (if (eq ?colourmap nil) then
    (return (long-to-bool (dc-set-colourmap ?self:id 0)))
  else
   (return (long-to-bool (dc-set-colourmap ?self:id (send ?colourmap get-id)))))
)

(defmessage-handler MAIN::wxDC set-clipping-region (?x1 ?y1 ?x2 ?y2)
  (return (long-to-bool (dc-set-clipping-region ?self:id ?x1 ?y1 ?x2 ?y2)))
)

(defmessage-handler MAIN::wxDC set-font (?font)
  (if (eq ?font nil) then
    (return (long-to-bool (dc-set-font ?self:id 0)))
  else
    (return (long-to-bool (dc-set-font ?self:id (send ?font get-id)))))
)

(defmessage-handler MAIN::wxDC set-logical-function (?op)
  (return (long-to-bool (dc-set-logical-function ?self:id ?op)))
)

(defmessage-handler MAIN::wxDC set-pen (?pen)
  (if (eq ?pen nil) then
    (return (long-to-bool (dc-set-pen ?self:id 0)))
   else
    (return (long-to-bool (dc-set-pen ?self:id (send ?pen get-id)))))
)

(defmessage-handler MAIN::wxDC set-brush (?brush)
  (return (long-to-bool (dc-set-brush ?self:id (send ?brush get-id))))
)

(defmessage-handler MAIN::wxDC set-text-foreground (?colour)
  (return (long-to-bool (dc-set-text-foreground ?self:id ?colour)))
)

(defmessage-handler MAIN::wxDC set-text-background (?colour)
  (return (long-to-bool (dc-set-text-background ?self:id ?colour)))
)


;;; ======================================================================
;;; DEFMESSAGE-HANDLERS for wxCanvasDC
;;; ======================================================================

;;; ======================================================================
;;; DEFMESSAGE-HANDLERS for wxMemoryDC
;;; ======================================================================

(defmessage-handler MAIN::wxMemoryDC create ()

  (bind ?self:id (memory-dc-create))
  (instance-table-add-entry ?self:id (instance-name ?self))

  (send ?self add-event-handlers)
)

(defmessage-handler MAIN::wxMemoryDC select-object (?bitmap)
  (if (eq ?bitmap nil) then
    (return (long-to-bool (memory-dc-select-object ?self:id 0)))
   else
   (return (long-to-bool (memory-dc-select-object ?self:id (send ?bitmap get-id))))
  )
)

;;; ======================================================================
;;; DEFMESSAGE-HANDLERS for wxMetaFileDC
;;; ======================================================================

(defmessage-handler MAIN::wxMetaFileDC create ()

  (if (neq ?self:filename "") then 
    (bind ?self:id (metafile-dc-create ?self:filename))
      else
    (bind ?self:id (metafile-dc-create)))

  (instance-table-add-entry ?self:id (instance-name ?self))

  (send ?self add-event-handlers)
)

(defmessage-handler MAIN::wxMetaFileDC close ()
  ; Should actually create a wxMetaFile object at this point
  (return (metafile-dc-close ?self:id))
)

;;; ======================================================================
;;; DEFMESSAGE-HANDLERS for wxPostScriptDC
;;; ======================================================================

(defmessage-handler MAIN::wxPostScriptDC create ()
  (bind ?window-id 0)
  (if (neq ?self:window nil) then (bind ?window-id (send ?self:window get-id)))
  
  (bind ?self:id (postscript-dc-create ?self:filename (bool-to-long ?self:interactive) ?window-id))

  (instance-table-add-entry ?self:id (instance-name ?self))

  (send ?self add-event-handlers)
)

;;; ======================================================================
;;; DEFMESSAGE-HANDLERS for wxPrinterDC
;;; ======================================================================

(defmessage-handler MAIN::wxPrinterDC create ()
  (bind ?self:id (printer-dc-create ?self:filename ?self:driver ?self:device
     ?self:filename (bool-to-long ?self:interactive)))

  (instance-table-add-entry ?self:id (instance-name ?self))

  (send ?self add-event-handlers)
)


