;;; ======================================================================
;;; wx_canvs.clp
;;; ======================================================================

(defclass MAIN::wxCanvas (is-a wxWindow)
  (role concrete)
  (slot dc
    (create-accessor read-write)
    (visibility public)
    (default nil))
)

;;; ======================================================================
;;; DEFMESSAGE-HANDLERS
;;; ======================================================================

(defmessage-handler MAIN::wxCanvas create ()

        (send ?self win-init)

	;; Create the canvas.
        (bind ?parent-id 0)
        (if (neq ?self:parent nil) then (bind ?parent-id (send ?self:parent get-id)))
	(bind ?self:id
		(canvas-create	?parent-id
				?self:x
				?self:y
				?self:width
				?self:height
				?self:style
				?self:window-name
        ))
        (bind ?self:dc (make-instance (gensym) of wxCanvasDC (id (canvas-get-dc ?self:id))))
        
        (instance-table-add-entry ?self:id (instance-name ?self))
        (send ?self add-event-handlers)
)

(defmessage-handler MAIN::wxCanvas delete before ()
  (if (instance-existp ?self:dc) then (send ?self:dc delete))
  (bind ?self:dc nil)

  (if (and (neq ?self:pending-delete TRUE)
           (eq 1 (wxclips-object-exists ?self:id))
      )
    then
    (instance-table-delete-entry ?self:id)
    (dynamic-put pending-delete TRUE)
    (window-delete ?self:id)
  )
  (return TRUE)
)

; get-dc seems to be a system handler !!!
(defmessage-handler MAIN::wxCanvas get-canvas-dc ()
  (return (canvas-get-dc ?self:id))
)

(defmessage-handler MAIN::wxCanvas set-scrollbars (?x-unit-size ?y-unit-size ?x-length ?y-length
  ?x-page-length ?y-page-length)

  (return (long-to-bool (canvas-set-scrollbars ?self:id ?x-unit-size ?y-unit-size ?x-length ?y-length
   ?x-page-length ?y-page-length)))
)

(defmessage-handler MAIN::wxCanvas scroll (?x-pos ?y-pos)
  (return (long-to-bool (canvas-scroll ?self:id ?x-pos ?y-pos)))
)


