;;; toolbar.clp
;;; Toolbar example.
;;; Load using -clips <file> on the command line or using the Batch
;;; or Load commands from the CLIPS development window; type
;;; (app-on-init) to start.

(defglobal ?*main-frame* = 0)
(defglobal ?*toolbar* = 0)
(defglobal ?*palette* = 0)
(defglobal ?*text-win* = 0)
(defglobal ?*subframe* = 0)

(defglobal ?*tool1* = 0)
(defglobal ?*tool2* = 0)
(defglobal ?*tool3* = 0)

(defglobal ?*tool10* = 0)
(defglobal ?*tool11* = 0)
(defglobal ?*tool12* = 0)
(defglobal ?*tool13* = 0)
(defglobal ?*tool14* = 0)
(defglobal ?*tool15* = 0)
(defglobal ?*tool16* = 0)
(defglobal ?*tool17* = 0)

(defglobal ?*small_font* = 0)
(defglobal ?*green_pen* = 0)
(defglobal ?*black_pen* = 0)
(defglobal ?*red_pen* = 0)
(defglobal ?*cyan_brush* = 0)
(defglobal ?*light_grey_brush* = 0)

(defglobal ?*xpos* = -1.0)
(defglobal ?*ypos* = -1.0)

;;; Toolbar callbacks
(deffunction my-toolbar-on-left-click (?toolbar ?tool-id ?toggle)
  (switch ?tool-id
    (case 1 then (printout t "Toolbar: New file" crlf))
    (case 2 then (printout t "Toolbar: Open file" crlf))
    (case 3 then (printout t "Toolbar: Save file" crlf))
  )
  (return 1)
)

(deffunction my-toolbar-on-right-click (?toolbar ?tool-id ?x ?y)
  (switch ?tool-id
    (case 1 then (printout t "Toolbar: New file (right click)" crlf))
    (case 2 then (printout t "Toolbar: Open file (right click)" crlf))
    (case 3 then (printout t "Toolbar: Save file (right click)" crlf))
  )
  (return 1)
)

(deffunction my-toolbar-on-mouse-enter(?toolbar ?tool-id)
  (switch ?tool-id
    (case 1 then (frame-set-status-text ?*main-frame* "Creates a new file"))
    (case 2 then (frame-set-status-text ?*main-frame* "Opens an existing file"))
    (case 3 then (frame-set-status-text ?*main-frame* "Saves the current file"))
    (case -1 then (frame-set-status-text ?*main-frame* ""))
  )
  (return 1)
)

;;; Sizing callback
(deffunction on-size (?id ?w ?h)
 (if (and (neq ?id 0) (neq ?*toolbar* 0) (neq ?*text-win* 0)) then
  (bind ?client-width (window-get-client-width ?id))
  (bind ?client-height (window-get-client-height ?id))
  (window-set-size ?*toolbar* 0 0 ?client-width 28)
  (window-set-size ?*text-win* 0 28 ?client-width (- ?client-height 28))
 )
)

;;; Painting callback
(deffunction on-paint (?id)
 (if (neq ?id 0) then
  (bind ?dc (canvas-get-dc ?id))
  (dc-set-font ?dc ?*small_font*)
  (dc-set-pen ?dc ?*green_pen*)
  (dc-draw-line ?dc 0.0 0.0 200.0 200.0)
  (dc-draw-line ?dc 200.0 0.0 0.0 200.0)

  (dc-set-pen ?dc ?*red_pen*)
  (dc-set-brush ?dc ?*cyan_brush*)
  (dc-draw-rectangle ?dc 100.0 100.0 100.0 50.0)
  (dc-draw-rounded-rectangle ?dc 150.0 150.0 100.0 50.0)

  (dc-set-clipping-region ?dc 150.0 150.0 100.0 50.0)
  (dc-draw-text ?dc "This text should be clipped within the rectangle" 150.0 170.0)
  (dc-destroy-clipping-region ?dc)

  (dc-draw-ellipse ?dc 250.0 250.0 100.0 50.0)
  (dc-draw-spline ?dc (mv-append 50.0 200.0 50.0 100.0 200.0 10.0))
  (dc-draw-line ?dc 50.0 230.0 200.0 230.0)
  (dc-draw-text ?dc "This is a test string" 50.0 230.0)
 )
)

(deffunction on-event (?canvas ?event)
  (bind ?dc (canvas-get-dc ?canvas))
  (dc-set-pen ?dc ?*black_pen*)
  (bind ?x (mouse-event-position-x ?event))
  (bind ?y (mouse-event-position-y ?event))
  (bind ?dragging (mouse-event-dragging ?event))
  (if (and (> ?*xpos* -1) (> ?*ypos* -1) (> ?dragging 0)) then
   (dc-draw-line ?dc ?*xpos* ?*ypos* ?x ?y)
  )
  (bind ?*xpos* ?x)
  (bind ?*ypos* ?y)
)

(deffunction on-close (?frame)
 (window-delete ?*subframe*)
 1)

(deffunction on-menu-command (?frame ?id)
 (if (eq ?id 200) 
  then (message-box "wxCLIPS toolbar demo
by Julian Smart (c) 1995" wxOK 1 0 "About this program")
  else
  (if (eq ?id 3) then 
   (on-close ?frame)
   (window-delete ?frame)
   else (if (eq ?id 1) then
    (bind ?file (file-selector "Choose a text file to load"))
    (if (neq ?file "") then
     (text-window-load-file ?*text-win* ?file)))
   ))
 )

;;; Button callback
(deffunction frame-button-proc (?id)
 (bind ?parent (window-get-parent ?id))
 (bind ?grandparent (window-get-parent ?parent))
 (format t "Pressed button %d%n" ?id)
 (message-box "Hello")
)

;;; Test program to create a frame
(deffunction app-on-init ()
  (bind ?*main-frame* 0)
  (bind ?*toolbar* 0)
  (bind ?*palette* 0)
  (bind ?*text-win* 0)
  (bind ?*subframe* 0)

  (unwatch all)
  (if (= ?*small_font* 0) then
    (bind ?*small_font* (font-create 10 wxSWISS wxNORMAL wxNORMAL 0))
    (bind ?*green_pen* (pen-create GREEN 1 wxSOLID))
    (bind ?*black_pen* (pen-create BLACK 1 wxSOLID))
    (bind ?*red_pen* (pen-create RED 3 wxSOLID))
    (bind ?*cyan_brush* (brush-create CYAN wxSOLID))
    (bind ?*light_grey_brush* (brush-create "LIGHT GREY" wxSOLID))
  )
  ; Load bitmaps for toolbar
  (bind ?*tool1* (bitmap-load-from-file "new.bmp" wxBITMAP_TYPE_BMP))
  (bind ?*tool2* (bitmap-load-from-file "open.bmp" wxBITMAP_TYPE_BMP))
  (bind ?*tool3* (bitmap-load-from-file "save.bmp" wxBITMAP_TYPE_BMP))

  ; Load bitmaps for palette
  (bind ?*tool10* (bitmap-load-from-file "abacus.bmp" wxBITMAP_TYPE_BMP))
  (bind ?*tool11* (bitmap-load-from-file "brush.bmp" wxBITMAP_TYPE_BMP))
  (bind ?*tool12* (bitmap-load-from-file "calc.bmp" wxBITMAP_TYPE_BMP))
  (bind ?*tool13* (bitmap-load-from-file "chart.bmp" wxBITMAP_TYPE_BMP))
  (bind ?*tool14* (bitmap-load-from-file "files.bmp" wxBITMAP_TYPE_BMP))
  (bind ?*tool15* (bitmap-load-from-file "magnify.bmp" wxBITMAP_TYPE_BMP))
  (bind ?*tool16* (bitmap-load-from-file "mike.bmp" wxBITMAP_TYPE_BMP))
  (bind ?*tool17* (bitmap-load-from-file "page.bmp" wxBITMAP_TYPE_BMP))

  (bind ?*main-frame* (frame-create 0 "wxCLIPS Toolbar Demo" -1 -1 500 450))
  (frame-create-status-line ?*main-frame*)
  (frame-set-status-text ?*main-frame* "Welcome to wxCLIPS")

  (window-add-callback ?*main-frame* OnSize on-size)
  (window-add-callback ?*main-frame* OnClose on-close)
  (window-add-callback ?*main-frame* OnMenuCommand on-menu-command)

  ;;; Make a menu bar
  (bind ?file-menu (menu-create))
  (menu-append ?file-menu 1 "&Load file")

  (bind ?pull-right (menu-create))
  (menu-append ?pull-right 100 "&Twips")
  (menu-append ?pull-right 101 "&10th mm")

  (menu-append ?file-menu 2 "&Scale picture" ?pull-right)
  (menu-append-separator ?file-menu)
  (menu-append ?file-menu 3 "&Quit")

  (bind ?help-menu (menu-create))
  (menu-append ?help-menu 200 "&About")

  (bind ?menu-bar (menu-bar-create))
  (menu-bar-append ?menu-bar ?file-menu "&File")
  (menu-bar-append ?menu-bar ?help-menu "&Help")

  (frame-set-menu-bar ?*main-frame* ?menu-bar)

  ;;; Make a toolbar

  (bind ?*toolbar* (toolbar-create ?*main-frame* 0 0 500 250 "" wxVERTICAL 1 1))
  (panel-set-button-font ?*toolbar* ?*small_font*)
  (window-add-callback ?*toolbar* OnLeftClick my-toolbar-on-left-click)
  (window-add-callback ?*toolbar* OnRightClick my-toolbar-on-right-click)
  (window-add-callback ?*toolbar* OnMouseEnter my-toolbar-on-mouse-enter)

  (bind ?dc (canvas-get-dc ?*toolbar*))
  (dc-set-background ?dc ?*light_grey_brush*)

  (toolbar-add-tool ?*toolbar* 1 ?*tool1* 0 0 10 3 0 "Tool 1")
  (toolbar-add-tool ?*toolbar* 2 ?*tool2* 0 0 37 3 0 "Tool 2")
  (toolbar-add-tool ?*toolbar* 3 ?*tool3* 0 0 64 3 0 "Tool 3")
  
  ; Required for Windows 95 toolbars, harmless for other kinds
  (toolbar-create-tools ?*toolbar*)
  
  ; Add a choice item: TAKE THIS CODE OUT for XView, because toolbars
  ; are not panels due to gaps in XView functionality.

  (bind ?choice (choice-create ?*toolbar* "" "" 90 3 100 -1 (mv-append
   "One" "Two" "Three" "Four")))
  (choice-set-selection ?choice 0)

  (bind ?*text-win* (text-window-create ?*main-frame* 0 250 500 300))

  (text-window-load-file ?*text-win* "toolbar.clp")

  ; Create a subframe for the floating tool palette
  (bind ?*subframe* (frame-create ?*main-frame* "Palette" 100 100 200 300
     "wxSDI | wxTINY_CAPTION_HORIZ | wxSYSTEM_MENU"))

  ; Create a palette that does NOT use automatic 3D buttons (the final 0)
  (bind ?*palette* (toolbar-create ?*subframe* 0 0 500 250 "" wxVERTICAL 2 0))

  (window-add-callback ?*toolbar* OnLeftClick my-toolbar-on-left-click)
  (window-add-callback ?*toolbar* OnRightClick my-toolbar-on-right-click)
  (window-add-callback ?*toolbar* OnMouseEnter my-toolbar-on-mouse-enter)

  (bind ?dc (canvas-get-dc ?*palette*))
  (dc-set-background ?dc ?*light_grey_brush*)

  (toolbar-add-tool ?*palette* 1 ?*tool10* 0 1)
  (toolbar-add-tool ?*palette* 2 ?*tool11* 0 1)
  (toolbar-add-tool ?*palette* 3 ?*tool12* 0 1)
  (toolbar-add-tool ?*palette* 4 ?*tool13* 0 1)
  (toolbar-add-tool ?*palette* 5 ?*tool14* 0 1)
  (toolbar-add-tool ?*palette* 6 ?*tool15* 0 1)
  (toolbar-add-tool ?*palette* 7 ?*tool16* 0 1)
  (toolbar-add-tool ?*palette* 8 ?*tool17* 0 1)

  ; Layout the tools
  (toolbar-layout ?*palette*)

  ; Size the palette frame to match the tools
  (bind ?w (toolbar-get-max-width ?*palette*))
  (bind ?h (toolbar-get-max-height ?*palette*))
  (window-set-client-size ?*subframe* ?w ?h)

  (window-centre ?*main-frame* wxBOTH)

;  (bind ?ide (get-ide-window))
;  (if (neq ?ide 0) then
;   (frame-iconize ?ide 1)
;  )
  (window-show ?*main-frame* 1)
  (window-show ?*subframe* 1)

  ?*main-frame*)
