;;; resource.clp
;;; Demonstrates use of dialog resources using a .wxr file.
;;; Load using -clips <file> on the command line or using the Batch
;;; or Load commands from the CLIPS development window; type
;;; (app-on-init) to start.

(defglobal ?*main-frame* = 0)

(deffunction on-close (?frame)
 1)
 
(deffunction dialog-on-command (?dialog ?item ?command)
 (bind ?name (window-get-name ?item))
 (printout t "dialog-on-command, item name is " ?name crlf)
 (switch ?name
  (case "button8"
    then (progn
     (window-show ?dialog 0)
     (window-delete ?dialog)))
  (case "button7"
    then (progn
     (window-show ?dialog 0)
     (window-delete ?dialog))
  )
 )
)
 
(deffunction resource-test ()
  (bind ?dialog (dialog-box-create-from-resource 0 "dialog1"))
  (window-add-callback ?dialog OnCommand dialog-on-command)
  (window-show ?dialog 1)
)

(deffunction on-menu-command (?frame ?id)
 (switch ?id
  (case 200 then (message-box "Resource demo
by Julian Smart (c) 1996" wxOK 1 0 "About Resource Demo"))
  (case 3 then (if (on-close ?frame) then (window-delete ?frame)))
  (case 1 then 
    (resource-test))
 )
)

;;; Button callback
(deffunction button-proc (?id)
 (format t "Pressed button %d%n" ?id)
 (message-box "Hello")
)

;;; Test program to create a frame
(deffunction app-on-init ()
  (unwatch all)
  
  (load-resource-file "dialog1.wxr")
  (load-resource-file "menu1.wxr")

  (bind ?*main-frame* (frame-create 0 "wxCLIPS Resource Sample" -1 -1 300 300))
  (frame-create-status-line ?*main-frame*)
  (frame-set-status-text ?*main-frame* "Welcome to wxCLIPS")

  (window-add-callback ?*main-frame* OnClose on-close)
  (window-add-callback ?*main-frame* OnMenuCommand on-menu-command)

  ;;; Make a menu bar
  (bind ?menu-bar (menu-bar-create-from-resource "menu1"))

  (frame-set-menu-bar ?*main-frame* ?menu-bar)

  (window-centre ?*main-frame* wxBOTH)

  (window-show ?*main-frame* 1)
  ?*main-frame*)

