;;; rescool.clp
;;; Demonstrates loading resources using wxCOOL.

(defclass MAIN::NewFrame (is-a wxFrame)
  (role concrete)
)

(defclass MAIN::MyDialogBox (is-a wxDialogBox)
  (role concrete)
)

(defmessage-handler MAIN::NewFrame on-close ()
  (return TRUE)
)

(defmessage-handler MAIN::MyDialogBox on-command (?item ?command-event)
 (printout t "*** MyDialogBox Got item event" crlf)
 (printout t "*** Item has name " (send ?item get-window-name) ", class " (class ?item) crlf)
 (bind ?name (send ?item get-window-name))
 (switch ?name
  (case "button8"
    then (progn
     (send ?self show FALSE)
     (send ?self delete)))
  (case "button7"
    then (progn
     (send ?self show FALSE)
     (send ?self delete)))
 )
)

(defmessage-handler MAIN::NewFrame on-menu-command (?command)
  (printout t "*** NewFrame Got menu item command " ?command crlf)
  (switch ?command
    (case 1 then
      (progn
       (bind ?dialog (make-instance (gensym*) of MyDialogBox (parent ?self) (resource "dialog1")))

       ; Find multitext item in dialog
       (bind ?mtext (send ?dialog find-window-by-name "multitext3"))

       (printout t "The contents of multitext3 is " (send ?mtext get-value) crlf)

       (send ?dialog show TRUE)
      )
    )
    (case 2 then (printout t "Close a file" crlf))
    (case 3 then (send ?self delete))
  )
)

(deffunction app-on-init ()
 (wxcool-init)

 (load-resource-file "dialog1.wxr")
 (load-resource-file "menu1.wxr")

 (make-instance [*main-frame*] of NewFrame (title "wxCOOL Resource Sample") (x -1) (y -1) (width 300) (height 300))

 (send [*main-frame*] create-status-line)
 (send [*main-frame*] set-status-text "Welcome to wxCOOL")

 (make-instance [menu-bar] of wxMenuBar (resource "menu1"))

 (send [*main-frame*] set-menu-bar [menu-bar])
 
 (send [*main-frame*] centre wxBOTH)

  ;;; Make a panel and panel items
 (send [*main-frame*] show TRUE)
 (return (send [*main-frame*] get-id))
)
