;;; Demos right-click on a diagram card and popping up a menu.
;;; Load this file and then call app-on-init before creating a new
;;; diagram card and right-clicking.

(defglobal ?*menu* = 0)
(defglobal ?*card* = 0)

(deffunction menu-callback (?item)
 (bind ?event (panel-item-get-command-event))
 (switch (command-event-get-selection ?event)
  (case 1 then (message-box "One" wxOK))
  (case 2 then (message-box "Two" wxOK))
  (default then return)
 )
)

(deffunction canvas-right-click (?card-id ?x ?y ?shift ?control)
  (printout t "Right click at " ?x ", " ?y crlf)
  (diagram-card-popup-menu ?card-id ?*menu* ?x ?y)
  (return 0)
)

(deffunction app-on-init ()
  (register-event-handler CanvasRightClick "Test" canvas-right-click)
  (bind ?*menu* (menu-create "" menu-callback))
  (menu-append ?*menu* 1 "One")
  (menu-append ?*menu* 2 "Two")
  (menu-append-separator ?*menu*)
  (menu-append ?*menu* 3 "Exit")
  (return 0)
)
