;;; This file shows how to code menu and toolbar replacement
;;; functionality.

(deffunction create-toolbar (?parent)
 (bind ?window (panel-create ?parent 0 0 300 40))

 (button-create ?window "" "Hello")
 (return ?window)
)

(deffunction create-card-toolbar (?card ?parent)
 (bind ?window (panel-create ?parent 0 0 300 40))

 (button-create ?window "" "Hello, diagram card")
 (return ?window)
)

(deffunction create-menubar ()
 ;;; Make a menu bar
 (bind ?file-menu (menu-create))
 (menu-append ?file-menu 800 "&Load file")
 (menu-append ?file-menu 801 "&Print to PostScript")

 (bind ?pull-right (menu-create))
 (menu-append ?pull-right 802 "&Twips")
 (menu-append ?pull-right 803 "&10th mm")

 (menu-append ?file-menu 804 "&Scale picture" ?pull-right)
 (menu-append-separator ?file-menu)
 (menu-append ?file-menu 805 "E&xit")

 (bind ?help-menu (menu-create))
 (menu-append ?help-menu 806 "&About")

 (bind ?menu-bar (menu-bar-create))
 (menu-bar-append ?menu-bar ?file-menu "&File")
 (menu-bar-append ?menu-bar ?help-menu "&Help")

 (return ?menu-bar)
)

(deffunction create-card-menubar (?card)
 ;;; Make a menu bar
 (bind ?file-menu (menu-create))
 (menu-append ?file-menu 800 "&Load file")
 (menu-append ?file-menu 801 "&Print to PostScript")

 (bind ?pull-right (menu-create))
 (menu-append ?pull-right 802 "&Twips")
 (menu-append ?pull-right 803 "&10th mm")

 (menu-append ?file-menu 804 "&Scale picture" ?pull-right)
 (menu-append-separator ?file-menu)
 (menu-append ?file-menu 807 "&Delete")
 (menu-append ?file-menu 805 "&Quit")

 (bind ?help-menu (menu-create))
 (menu-append ?help-menu 806 "&About")

 (bind ?menu-bar (menu-bar-create))
 (menu-bar-append ?menu-bar ?file-menu "&File")
 (menu-bar-append ?menu-bar ?help-menu "&Help")

 (return ?menu-bar)
)

(deffunction process-menu-commands (?id)
 (switch ?id
  (case 805 then
    (bind ?actual-id (hardy-command-string-to-int "HardyExit"))
    (hardy-send-command ?actual-id))
  (case dummy then return)
  (default (hardy-send-command ?id)))
 (return 0)
)

(deffunction process-card-menu-commands (?card ?id)
 (switch ?id
  (case 805 then
    (bind ?actual-id (hardy-command-string-to-int "CardQuit"))
    (card-send-command ?card ?actual-id))
  (case 807 then
    (bind ?actual-id (hardy-command-string-to-int "CardDelete"))
    (card-send-command ?card ?actual-id))
  (default (card-send-command ?card ?id)))
 (return 0)
)

(register-event-handler OnCreateToolBar Toplevel create-toolbar)
;(register-event-handler OnCreateMenuBar Toplevel create-menubar)
(register-event-handler OnMenuCommand Toplevel process-menu-commands)

(register-event-handler OnCreateMenuBar Test create-card-menubar)
(register-event-handler OnCreateToolBar Test create-card-toolbar)
(register-event-handler OnMenuCommand Test process-card-menu-commands)


