;;; wxhtml.clp
;;; HTML viewer example
;;; Type (app-on-init) to start.

(defglobal ?*main-frame* = 0)
(defglobal ?*canvas* = 0)

;;; Sizing callback
(deffunction on-size (?id ?w ?h)
 (if (and (neq ?id 0) (neq ?*canvas* 0)) then
  (bind ?client-width (window-get-client-width ?id))
  (bind ?client-height (window-get-client-height ?id))
  (window-set-size ?*canvas* 0 0 ?client-width ?client-height)
  (html-resize ?*canvas*)
 )
)

;;; URL click callback
(deffunction on-open-url (?id ?url)
 (printout t "URL = " ?url crlf)
 (if (symbolp ?url) then (printout t "URL is a symbol" crlf))
 (if (eq ?url "julian") then
  (progn
   (printout t "Custom button!" crlf)
   (return 0)
  )
 )
 (return 1)
)

(deffunction on-close (?frame)
 (bind ?*canvas* 0)
 1)

(deffunction on-menu-command (?frame ?id)
 (switch ?id
  (case 200 then (message-box "HTML viewer demo
by Andrew Davison, Julian Smart (c) 1996" wxOK 1 0 "About HTML viewer Demo"))
  (case 3 then (if (on-close ?frame) then (window-delete ?frame)))
  (case 1 then 
    (bind ?file (file-selector "Choose an HTML file to load"))
    (if (neq ?file "") then
     (html-open-file ?*canvas* ?file)))
  (case 4 then
    (bind ?url (get-text-from-user "Enter a URL"))
    (if (neq ?url "") then
     (html-open-url ?*canvas* ?url))
  )
 )
)

;;; Test program to create a frame
(deffunction app-on-init ()
  (unwatch all)
  (bind ?*main-frame* (frame-create 0 "HTML viewer" -1 -1 500 460))
  (frame-create-status-line ?*main-frame*)
  (frame-set-status-text ?*main-frame* "Welcome to HTML viewer")

  (window-add-callback ?*main-frame* OnSize on-size)
  (window-add-callback ?*main-frame* OnClose on-close)
  (window-add-callback ?*main-frame* OnMenuCommand on-menu-command)

  ;;; Make a menu bar
  (bind ?file-menu (menu-create))
  (menu-append ?file-menu 1 "&Load file")
  (menu-append ?file-menu 4 "&Open URL")

  (menu-append-separator ?file-menu)
  (menu-append ?file-menu 3 "E&xit")

  (bind ?help-menu (menu-create))
  (menu-append ?help-menu 200 "&About")

  (bind ?menu-bar (menu-bar-create))
  (menu-bar-append ?menu-bar ?file-menu "&File")
  (menu-bar-append ?menu-bar ?help-menu "&Help")

  (frame-set-menu-bar ?*main-frame* ?menu-bar)

  (bind ?*canvas* (html-create ?*main-frame* 0 0 400 400))
  (window-add-callback ?*canvas* OnOpenURL on-open-url)

;  (html-open-file ?*canvas* "primer.htm")

  (window-centre ?*main-frame* wxBOTH)

  (window-show ?*main-frame* 1)

  ?*main-frame*)

