;;; grid.clp
;;; grid test
;;; Load using -clips <file> on the command line or using the Batch
;;; or Load commands from the CLIPS development window; type
;;; (app-on-init) to start.

(defglobal ?*main-frame* = 0)
(defglobal ?*grid* = 0)

(deffunction on-close (?frame)
 (format t "Closing frame.%n")
 (bind ?*grid* 0)
 1)

(deffunction on-activate (?frame ?active)
  (if (> ?*grid* 0) then (grid-on-activate ?*grid* ?active))
)

(deffunction on-menu-command (?frame ?id)
 (switch ?id
  (case 200 then (message-box "CLIPS for wxWindows Demo
by Julian Smart (c) 1993" wxOK 1 0 "About wxWindows CLIPS Demo"))
  (case 3 then (if (on-close ?frame) then (window-delete ?frame)))
 )
)

;;; Test program to create a frame
(deffunction app-on-init ()
  (unwatch all)

  (bind ?*main-frame* (frame-create 0 "wxCLIPS Grid Test" -1 -1 400 300))

  (window-add-callback ?*main-frame* OnClose on-close)
  (window-add-callback ?*main-frame* OnMenuCommand on-menu-command)
  (window-add-callback ?*main-frame* OnActivate on-activate)

  ;;; Make a menu bar
  (bind ?file-menu (menu-create))
  (menu-append ?file-menu 3 "&Quit")

  (bind ?menu-bar (menu-bar-create))
  (menu-bar-append ?menu-bar ?file-menu "&File")

  (frame-set-menu-bar ?*main-frame* ?menu-bar)

  ;;; Make a grid
  (bind ?*grid* (grid-create ?*main-frame* 0 0 400 300))
  (grid-create-grid ?*grid* 10 8)
  (grid-set-column-width ?*grid* 3 200)
  (grid-set-row-height ?*grid* 4 45)
  (grid-set-cell-value ?*grid* "First cell" 0 0)
  (grid-set-cell-value ?*grid* "Another cell" 1 1)
  (grid-set-cell-value ?*grid* "Yet another cell" 2 2)
  (grid-set-cell-text-font ?*grid* (font-create 12 wxROMAN wxITALIC wxNORMAL 0) 0 0)
  (bind ?red (colour-create RED))
  (grid-set-cell-text-colour ?*grid* ?red 1 1)
  (bind ?cyan (colour-create CYAN))
  (grid-set-cell-background-colour ?*grid* ?cyan 2 2)
  (grid-update-dimensions ?*grid*)

  (window-centre ?*main-frame* wxBOTH)

  (window-show ?*main-frame* 1)

  ?*main-frame*)

