/*
 * drag.cc
 * File generated by Clips2C from drag.clp
 * for HARDY compatibility
 */

#include "math.h"
#include "stdlib.h"
#include "wxstring.h"
#include "clipslib.h"
#include "wx_cmds.h"
#include "hapi.h"

/*
 * Function prototypes
 */

void drag_node_to_canvas(long card_id, long image_id, long attachment, float x, float y, long shift, long control);
void drag_canvas_to_node(long card_id, long image_id, long attachment, float x, float y, long shift, long control);
void drag_canvas_to_canvas(long card_id, float x1, float y1, float x2, float y2, long shift, long control);

/*
 * Global variables
 */


/*
 * Classes
 */


/*
 * Functions
 */

void drag_node_to_canvas(long card_id, long image_id, long attachment, float x, float y, long shift, long control)
{
  long image1;
  long image2;
;
  image1 = HardyNodeImageCreate(card_id, "Dummy Node");
  HardyDiagramImageMove(card_id, image1, x, y);
  image2 = HardyArcImageCreate(card_id, "Arc", image_id, image1, 0, 0);
}

void drag_canvas_to_node(long card_id, long image_id, long attachment, float x, float y, long shift, long control)
{
  long image1;
  long image2;
;
  image1 = HardyNodeImageCreate(card_id, "Dummy Node");
  HardyDiagramImageMove(card_id, image1, x, y);
  image2 = HardyArcImageCreate(card_id, "Arc", image1, image_id, 0, 0);
}

void drag_canvas_to_canvas(long card_id, float x1, float y1, float x2, float y2, long shift, long control)
{
  long image1;
  long image2;
  long image3;
;
  image1 = HardyNodeImageCreate(card_id, "Dummy Node");
  image2 = HardyNodeImageCreate(card_id, "Dummy Node");
  HardyDiagramImageMove(card_id, image1, x1, y1);
  HardyDiagramImageMove(card_id, image2, x2, y2);
  image3 = HardyArcImageCreate(card_id, "Arc", image1, image2, 0, 0);
}

/*
 * Top-level statements
 */

void ExecuteClipsStatements(void)
{
  HardyRegisterEventHandler("RightDragNodeToCanvas", "Drag Test", (wxClipsFunction)drag_node_to_canvas);
  HardyRegisterEventHandler("RightDragCanvasToNode", "Drag Test", (wxClipsFunction)drag_canvas_to_node);
  HardyRegisterEventHandler("RightDragCanvasToCanvas", "Drag Test", (wxClipsFunction)drag_canvas_to_canvas);
}

/*
 * Initialization function called by HARDY
 */

void gyInitializeCustomCode(void)
{
  ExecuteClipsStatements();
}
