;;; Tree-drawer demo
;;; Use -clips treeload.clp on HARDY command line.
;;; Create a tree card, create a root with the custom menu,
;;; then keep clicking on nodes to create children.

(defglobal ?*tree-root* = 0)

;;; Asks for a name and creates the tree root
(deffunction tree-add-root-image (?card-id)
  (bind ?msg (get-text-from-user "Enter name for new root node"))
  (if (eq ?msg "") then 0 else
   ; Create a new image
   (bind ?image1 (create-node-image ?card-id "Node"))

   ; Find it's underlying node object
   (bind ?object1 (get-object-from-image ?card-id ?image1))

   ; Set the name attribute
   (set-object-string-attribute ?card-id ?object1 "name" ?msg)

   ; Format the text on the image
   (format-object-text ?card-id ?object1)
 
   (bind ?*tree-root* ?image1)
   ; Layout the tree
   (diagram-layout-tree ?card-id ?*tree-root*))
 )

;;; Callback for custom menu
(deffunction tree-menu-handler (?card-id ?option)
 (if (eq ?option "Add root") then
     (tree-add-root-image ?card-id) else
  (if (eq ?option "Layout tree") then
     (diagram-layout-tree ?card-id ?*tree-root*)))
)

;;; Left-click handler to create children
(deffunction tree-node-handler (?card-id ?image-id ?x ?y ?shift ?control)
  (declare ?x float)
  (declare ?y float)
  (if (and (neq ?shift 1) (neq ?control 1)) then
    (bind ?msg (get-text-from-user "Enter name for new node"))
    (if (eq ?msg "") then 0 else

     ; Create a node image
     (bind ?image1 (create-node-image ?card-id "Node"))

     ; Get the underlying node object
     (bind ?object1 (get-object-from-image ?card-id ?image1))

     ; Set the name attribute
     (set-object-string-attribute ?card-id ?object1 "name" ?msg)

     ; Format the text on the image
     (format-object-text ?card-id ?object1)

     ; Add an arc
     (bind ?image3 (create-arc-image ?card-id "Arc" ?image-id ?image1 1 3))

     ; Layout the tree
     (diagram-layout-tree ?card-id ?*tree-root*)
     0)
  else 1)
)

;;; Handler for the user deleting images
(deffunction tree-delete-image-handler (?card-id ?image-id ?type)
 (declare ?type string)
 (if (eq ?image-id ?*tree-root*) then
  (bind ?*tree-root* 0) else
  (diagram-layout-tree ?card-id ?*tree-root*)
 )
)


