;;; File:     report.clp
;;; Purpose:  Top-level code to generate a report
;;; Author:   Julian Smart
;;; Created:  16/7/94
;;; Needs:    latex.clp, utils1.clp, ddeword.clp
;;;
;;;
;;; Description:
;;; ============
;;;
;;; (print-report-rtf ?card-id)
;;;     Prints the card hierarchy from the given card to Word format,
;;;     and loads the document.
;;;
;;; (print-report-winhelp ?card-id)
;;;     Prints the card hierarchy from the given card to Windows Help format,
;;;     compiling the help file from RTF to HLP, then showing the
;;;     help file.

(defglobal ?*report-filename* = "report.tex")

;; Popup a file selector and print a linear RTF (word processor) report
(deffunction print-report-rtf (?card-id)
  (bind ?filename (file-selector "Filename for report" (get-path ?*report-filename*) (get-file ?*report-filename*)
                                       "tex" "*.tex"))
  (if (neq ?filename "") then
   (bind ?*report-filename* ?filename)
   (write-all ?card-id ?filename)
   (tex-convert ?filename 0)
   (word-load (str-cat (strip-extension ?filename) ".rtf"))
  )
)

;; Popup a file selector and print a WinHelp RTF (Windows Help) report
(deffunction print-report-winhelp (?card-id)
  (bind ?filename (file-selector "Filename for report" (get-path ?*report-filename*) (get-file ?*report-filename*)
                                       "tex" "*.tex"))
  (if (neq ?filename "") then
   (bind ?*report-filename* ?filename)
   (write-all ?card-id ?*report-filename*)
   (tex-convert ?*report-filename* 1)

   ;;; Write a batch file to call the Help Compiler
   (open "temp.bat" batch-file "w")
   (printout batch-file "@echo off" crlf)
   (printout batch-file (str-cat "cd " (get-path ?*report-filename*)) crlf)
   (printout batch-file (str-cat "call hc.bat " (strip-extension ?*report-filename*)) crlf)
   (printout batch-file "pause" crlf)
   (close batch-file)

   (system "temp.bat")
   (message-box "Please press OK when the help file has been compiled.")
   (system (str-cat "winhelp.exe " (strip-extension ?*report-filename*) ".hlp"))
  )
)



