;;; File:     ddeword.clp
;;; Purpose:  Functions to handle connection to Word and Tex2RTF
;;; Author:   Julian Smart
;;; Created:  16/7/94
;;;
;;; Description:
;;; ============
;;; This file implements DDE functionality for loading a document into
;;; Word for Windows, and also for converting from Latex to RTF using
;;; Tex2RTF (again controlled by DDE).
;;;
;;; (word-load ?filename)
;;;     Attempts to load an RTF document into Word.
;;;
;;; (tex-convert ?filename ?gen-winhelp)
;;;     Converts from Latex to RTF.
;;;     If ?gen-winhelp is 1, WinHelp RTF is generated instead of
;;;     word-processor WinHelp, and an HPJ project file is generated.
;;;     Run the help compiler (hc.bat) to generate the .HLP file.
;;;
;;; Bugs
;;; ====
;;; 1.  Doesn't check to see if Word already has the file, so Tex2RTF
;;;     causes a sharing violation if report.rtf is already in Word.

;;; Word connection
(defglobal ?*word-server* = 0)
(defglobal ?*word-server-name* = "WinWord")
(defglobal ?*word-host-name* = "none")
(defglobal ?*word-topic-name* = "System")
(defglobal ?*word-client* = 0)
(defglobal ?*word-connection* = 0)

;;; Tex2RTF connection
(defglobal ?*tex-server* = 0)
(defglobal ?*tex-server-name* = "TEX2RTF")
(defglobal ?*tex-host-name* = "none")
(defglobal ?*tex-topic-name* = "TEX2RTF")
(defglobal ?*tex-client* = 0)
(defglobal ?*tex-connection* = 0)

(deffunction word-load (?filename)
 ;; Get a group name from the user
 (bind ?pathname (get-path ?filename))

 ;; Form command
 (bind ?command (many-strings-to-one
   (mv-append "[ChDir \"" ?pathname "\"][FileOpen .Name = \"" ?filename "\"]")))

 (printout t "Sending message " ?command)
 ;; Construct a client object
 (bind ?*word-client* (client-create))

 ;; Construct a connection object
 (bind ?*word-connection* (client-make-connection
            ?*word-client* ?*word-host-name*
            ?*word-server-name* ?*word-topic-name*))

 (if (eq ?*word-connection* 0) then
  (system "winword.exe")
;  (message-box "Please load Word, and then press OK when Word has loaded.")
  (bind ?*word-connection* (client-make-connection
             ?*word-client* ?*word-host-name*
             ?*word-server-name* ?*word-topic-name*))
  (if (eq ?*word-connection* 0) then
   (message-box "Sorry, could not connect to Word. Check your PATH.")
   (return 0))
 )

 ;; Execute a command to read the file
 (bind ?exe (connection-execute ?*word-connection* ?command))

 ;; Disconnect
 (connection-disconnect ?*word-connection*)
 (return 1)
)

;;; Convert the given filename from Latex to RTF using
;;; Julian Smart's Tex2RTF
(deffunction tex-convert (?filename ?gen-winhelp)
 ;; Get a group name from the user
 (bind ?pathname (get-path ?filename))

 ;; Construct a client object
 (bind ?*tex-client* (client-create))

 ;; Form create group command
 (bind ?command (str-cat "INPUT " ?filename))

 ;; Construct a connection object
 (bind ?*tex-connection* (client-make-connection
            ?*tex-client* ?*tex-host-name*
            ?*tex-server-name* ?*tex-topic-name*))

 (if (eq ?*tex-connection* 0) then
  (system "tex2rtf.exe")
;  (message-box "Please load Tex2RTF, and then press OK when Tex2RTF has loaded.")
  (bind ?*tex-connection* (client-make-connection
             ?*tex-client* ?*tex-host-name*
             ?*tex-server-name* ?*tex-topic-name*))
  (if (eq ?*tex-connection* 0) then
   (message-box "Sorry, could not connect to Tex2RTF. Check your PATH.")
   (return 0))
 )

 ;; Execute a command to set the input file
 (printout t ?command)
 (bind ?exe (connection-execute ?*tex-connection* ?command))

 (bind ?command (str-cat "OUTPUT " (strip-extension ?filename) ".rtf"))
 (printout t ?command)
 (bind ?exe (connection-execute ?*tex-connection* ?command))

 ; Uncomment to minmize Tex2RTF
; (bind ?command "MINIMIZE")
; (printout t ?command)
; (bind ?exe (connection-execute ?*tex-connection* ?command))

 (if (eq ?gen-winhelp 1) then
   (bind ?command "conversionMode WinHelp") else
   (bind ?command "conversionMode RTF")
 )
 (printout t ?command)
 (bind ?exe (connection-execute ?*tex-connection* ?command))

 (if (eq ?gen-winhelp 1) then
  (connection-execute ?*tex-connection* "generateHPJ true"))

 (bind ?command "GO")
 (printout t ?command)
 (bind ?exe (connection-execute ?*tex-connection* ?command))
 
 ;; Disconnect
 (connection-disconnect ?*tex-connection*)
 (return 1)
)

