;;; odbc.clp
;;; ODBC database example.
;;; Load using -clips <file> on the command line or using the
;;; Load command from the CLIPS development window; type
;;; (app-on-init) to start.

(defglobal ?*main-frame* = 0)
(defglobal ?*panel* = 0)
(defglobal ?*sources-listbox* = 0)
(defglobal ?*tables-listbox* = 0)
(defglobal ?*columns-listbox* = 0)
(defglobal ?*error-msg* = 0)

(defglobal ?*database* = 0)
(defglobal ?*recordset* = 0)

(deffunction show-database-error ()
 (bind ?msg (database-get-error-message ?*database*))
 (multi-text-set-value ?*error-msg* ?msg)
)

(deffunction show-recordset-error ()
 (bind ?msg (database-get-error-message ?*database*))
 (multi-text-set-value ?*error-msg* ?msg)
)

(deffunction on-close (?frame)
 (format t "Closing frame.%n")
 (bind ?*panel* 0)

 (if (> ?*recordset* 0) then
   (recordset-delete ?*recordset*))

 (if (> ?*database* 0) then
   (database-close ?*database*)
   (database-delete ?*database*))
 (bind ?*database* 0)
 (bind ?*recordset* 0)
 1)

(deffunction on-menu-command (?frame ?id)
 (switch ?id
  (case 200 then (message-box "wxCLIPS ODBC demo
by Julian Smart (c) 1995" wxOK 1 0 "About wxWindows CLIPS Demo"))
  (case 3 then (if (on-close ?frame) then (window-delete ?frame)))
  (case 1 then 
    (bind ?file (file-selector "Choose a text file to load"))
;    (if (neq ?file "") then
;     (text-window-load-file ?*text-win* ?file))
  )
 )
)

;;; Sources listbox callback
(deffunction sources-proc (?id)
 (bind ?sel (list-box-get-string-selection ?*sources-listbox*))
 (if (neq ?sel "") then
  (database-close ?*database*)
  (database-open ?*database* ?sel)
  (if (eq 0 (recordset-get-tables ?*recordset*)) then
    (show-database-error) else

   ;;; Stuff table names into the tables listbox
   (list-box-clear ?*tables-listbox*)
   (list-box-clear ?*tables-listbox*)
   (bind ?cont 1)
   (while (eq ?cont 1)
    (bind ?data (recordset-get-char-data ?*recordset* 2))
    (list-box-append ?*tables-listbox* ?data)
    (bind ?cont (recordset-move-next ?*recordset*))
   )
  )
 )
)

;;; Tables listbox callback
(deffunction tables-proc (?id)
 (bind ?sel (list-box-get-string-selection ?*tables-listbox*))
 (if (neq ?sel "") then

  (recordset-set-table-name ?*recordset* ?sel)

  (if (eq 0 (recordset-get-columns ?*recordset*)) then
    (show-database-error) else

   ;;; Stuff column names into the columns listbox
   (list-box-clear ?*columns-listbox*)

   (bind ?cont 1)
   (while (eq ?cont 1)
    (bind ?data (recordset-get-char-data ?*recordset* 3))
    (list-box-append ?*columns-listbox* ?data)
    (bind ?cont (recordset-move-next ?*recordset*))
   )
  )
 )
)

;;; Columns listbox callback
(deffunction columns-proc (?id)
)

;;; Test program to create a frame
(deffunction app-on-init ()
  (unwatch all)

  (bind ?*main-frame* (frame-create 0 "wxCLIPS ODBC demo" -1 -1 500 460))
  (frame-create-status-line ?*main-frame*)
  (frame-set-status-text ?*main-frame* "Welcome to wxCLIPS")

  (window-add-callback ?*main-frame* OnClose on-close)
  (window-add-callback ?*main-frame* OnMenuCommand on-menu-command)

  ;;; Make a menu bar
  (bind ?file-menu (menu-create))
;  (menu-append ?file-menu 1 "&Load file")
;  (menu-append-separator ?file-menu)
  (menu-append ?file-menu 3 "&Quit")

  (bind ?help-menu (menu-create))
  (menu-append ?help-menu 200 "&About")

  (bind ?menu-bar (menu-bar-create))
  (menu-bar-append ?menu-bar ?file-menu "&File")
  (menu-bar-append ?menu-bar ?help-menu "&Help")

  (frame-set-menu-bar ?*main-frame* ?menu-bar)

  ;;; Make a panel and panel items
  (bind ?*panel* (panel-create ?*main-frame* 0 0 500 250))
  (panel-set-label-position ?*panel* wxVERTICAL)

  (bind ?*sources-listbox* (list-box-create ?*panel* "sources-proc" "Sources" 0 -1 -1 150 200))
  (bind ?*tables-listbox* (list-box-create ?*panel* "tables-proc" "Tables" 0 -1 -1 150 200))
  (bind ?*columns-listbox* (list-box-create ?*panel* "columns-proc" "Columns" 0 -1 -1 150 200))

  (panel-new-line ?*panel*)

  (bind ?*error-msg* (multi-text-create ?*panel* "" "Errors" "" -1 -1 450 100))

  (bind ?*database* (database-create))
  (bind ?*recordset* (recordset-create ?*database* "wxOPEN_TYPE_SNAPSHOT"))

  ;;; Get the list of currently-defined ODBC sources
  (if (eq 0 (recordset-get-data-sources ?*recordset*)) then

   (show-database-error) else

   ;;; Loop through all the source names (one per record)
   (bind ?cont 1)
   (while (eq ?cont 1)
    (bind ?data (recordset-get-char-data ?*recordset* 0))
    (list-box-append ?*sources-listbox* ?data)
    (bind ?cont (recordset-move-next ?*recordset*))
   )
  )

  (window-centre ?*main-frame* wxBOTH)
  (window-show ?*main-frame* 1)

  ?*main-frame*)

;;; Function for updating a field in a record in the incident.dbf demo
;;; file.
;;; E.g. (demo-update-integer "BD34" "X" 999)
;;; The key is the ASSET column, BD34 in the example. Record(s) matching
;;; this key will be changed.
;;; "X" is the name of the column to be updated.
;;; 999 is a value to replace the current value.
;;;
;;; You must have previously registered the file incident.dbf
;;; with ODBC (e.g. from the control panel), with the source
;;; name "wxCLIPS demo". You can check if the file has changed
;;; by using Microsoft Query, for example.

(deffunction demo-update-integer (?asset ?col ?value)
  (bind ?database (database-create))

  ;; Open data source
  (if (eq 0 (database-open ?database "wxCLIPS demo")) then
   (bind ?msg (database-get-error-message ?database))
   (printout t ?msg crlf)
   (return 0)
  )

  ;; Create a recordset
  (bind ?recordset (recordset-create ?database "wxOPEN_TYPE_SNAPSHOT"))

  ;; Construct an SQL statement
  (bind ?sql (str-cat "UPDATE Incident SET " ?col " = " ?value " WHERE ASSET = '" ?asset "'"))
  (printout t ?sql crlf)

  ;; Execute the SQL.
  (if (eq 0 (recordset-execute-sql ?recordset ?sql)) then

   (bind ?msg (database-get-error-message ?database))
   (printout t ?msg crlf)
   (return 0)
  )

  (recordset-delete ?recordset)
  (database-close ?database)
  (database-delete ?database)
  (return 1)
)

;;; Function for returning the value of an integer field.
;;; E.g. (demo-get-integer "BD34" "X")
;;; The key is the ASSET column, BD34 in the example. The first record matching
;;; this key will be returned.
;;; "X" is the name of the column whose value is to be returned.

(deffunction demo-get-integer (?asset ?col)
  (bind ?database (database-create))

  ;; Open data source
  (if (eq 0 (database-open ?database "wxCLIPS demo")) then
   (bind ?msg (database-get-error-message ?database))
   (printout t ?msg crlf)
   (return 0)
  )

  ;; Create a recordset
  (bind ?recordset (recordset-create ?database "wxOPEN_TYPE_SNAPSHOT"))

  ;; Construct an SQL statement
  (bind ?sql (str-cat "SELECT * FROM Incident WHERE ASSET = '" ?asset "'"))
  (printout t ?sql crlf)

  ;; Execute the SQL.
  (if (eq 0 (recordset-execute-sql ?recordset ?sql)) then

   (bind ?msg (database-get-error-message ?database))
   (printout t ?msg crlf)
   (return 0)
  )

  ;; Get the relevant field of the first record
  (bind ?data (recordset-get-int-data ?recordset ?col))

  (recordset-delete ?recordset)
  (database-close ?database)
  (database-delete ?database)
  (return ?data)
)

 

