;;; text.clp
;;; Converts text cards to HTML

;;; Copy from the text card's file into the new file.

(deffunction trans-copy-text (?card ?newfile)
 (bind ?cardfile (hardy-path-search (card-get-string-attribute ?card "filename")))
 (if (neq ?cardfile "") then
  (if (not (open ?cardfile oldfile "r")) then
   (bind ?msg (str-cat "Could not open file " ?cardfile))
   (message-box ?msg)
   (return 0)
  )
  (bind ?line (readline oldfile))
  (while (and (neq ?line EOF) (neq ?line FALSE))
   (printout ?newfile ?line crlf)
   (if (eq ?line ?*nl*)
    then (message-box "Yes!"))
   (bind ?line (readline oldfile))
  )
  (close oldfile)
 )
)

;;;
;;; Translate a text card
;;;

(deffunction trans-translate-text-card (?card)
 (trans-add-card ?card)
 (bind ?filename (str-cat ?*trans-output-path* "/" (trans-find-card-file ?card)))

 ;;; Open the HTML file
 (bind ?success (open ?filename tempfile "w"))
 (if (not ?success) then
   (printout t "Could not open file " ?filename crlf)
   (return)
 )

 ;;; Output the title
 (printout tempfile "<TITLE>" (card-get-string-attribute ?card "title") "</TITLE>" crlf)
 (printout tempfile "<H1>" (card-get-string-attribute ?card "title") "</H1>" crlf)
 (printout tempfile "<PRE>" crlf)
 ;;; Copy the text from the card into the new file
 (trans-copy-text ?card tempfile)
 (printout tempfile "</PRE>" crlf)

 ;;; Now append any links from the Special Item
 (printout tempfile "<HR>" crlf)
 (trans-write-special-links ?card tempfile)
 (close tempfile)
)




