;;; loader.clp
;;; Loads Hardy to HTML conversion utility
;;; Julian Smart 3/12/94
;;;
;;; Generates:
;;;  * a set of HTML files, one HTML file per card. The root name is used for the
;;;    contents page, and all other HTML files have names derived from the root.
;;;  * BMP files are generated for each diagram and converted to GIFs at the end
;;;    of translation using a DOS program
;;; Limitations:
;;;  * only works for the Windows Hardy version since the X version cannot generate
;;;    colour bitmaps
;;;  * each HTML link points to a file, not an item within a file
;;;  * if an item contains a link to more than one card, second and subsequent
;;;    links are ignored

;;; Globals
(load "globals.clp")

;;; Forward declarations
(load "forward.clp")

;;; Utilities
(load "utils.clp")

;;; Dialog box for entering pathname, etc.
(load "dialog.clp")

;; Diagram card conversion
(load "diagram.clp")

;; Hypertext card conversion
(load "hypertxt.clp")

;; Text card conversion
(load "text.clp")

;; Main conversion routine
(load "convert.clp")

;; Install a menu callback
(register-event-handler CustomMenu Toplevel trans-custom-menu)
