;;; hypertxt.clp
;;; Converts Hypertext cards to HTML

;;; Write link to another card, if there is one
(deffunction trans-hypertext-card-write-link (?card ?blockid ?start)
; (printout t "Writing link for block " ?blockid crlf)
 (bind ?itemid (hypertext-block-get-item ?card ?blockid))
 (if (> ?itemid -1) then
   (bind ?linkid (item-get-first-link ?card ?itemid))
   (if (> ?linkid -1) then
     (bind ?othercard (link-get-card-to ?linkid))
     (if (neq ?othercard ?card) then
      (trans-add-card ?othercard)
      (if ?start then
        (hypertext-card-translator-output ?card -1
         (str-cat "<a href=\"" ?*trans-actual-path* "/" (trans-find-card-file ?othercard) "\">")
        )
        else
        (hypertext-card-translator-output ?card -1 "</a>")
      )
     )
    )
  )
)

;;; Callback, called implicitly from within hypertext-card-translate,
;;; to translate blocks in a hypertext card.

(defglobal
 ?*block-type-stack* = (mv-append)
)

(deffunction trans-hypertext-card-translator (?card ?event ?blocktype ?blockid)
 (switch ?event
  ;;; Start block
  (case 1 then
    (bind ?*block-type-stack* (mv-append ?blocktype ?*block-type-stack*))

;    (printout t "Starting block: type stack is " ?*block-type-stack* crlf)

    ; Write link, if there is one
    (trans-hypertext-card-write-link ?card ?blockid TRUE)

    ; Note, these assume the default hypertext type (same as wxHelp)
    (switch ?blocktype
     ; Large heading/section
     (case 5 then (hypertext-card-translator-output ?card -1 "<H2>"))
     (case 10 then (hypertext-card-translator-output ?card -1 "<H2>"))
     ; Small heading/section
     (case 6 then (hypertext-card-translator-output ?card -1 "<H3>"))
     (case 11 then (hypertext-card-translator-output ?card -1 "<H3>"))
     ; Italic or red italic
     (case 7 then (hypertext-card-translator-output ?card -1 "<I>"))
     (case 13 then (hypertext-card-translator-output ?card -1 "<I>"))
     ; Bold/red/blue/green
     (case 8 then (hypertext-card-translator-output ?card -1 "<B>"))
     (case 2 then (hypertext-card-translator-output ?card -1 "<B>"))
     (case 3 then (hypertext-card-translator-output ?card -1 "<B>"))
     (case 4 then (hypertext-card-translator-output ?card -1 "<B>"))
     ; Teletype
     (case 14 then (hypertext-card-translator-output ?card -1 "<TT>"))
    )
  )
  ;;; End block
  (case 2 then
;    (printout t "Ending block: type stack is " ?*block-type-stack* crlf)
    (bind ?btype (nth$ 1 ?*block-type-stack*))
    (bind ?*block-type-stack* (rest$ ?*block-type-stack*))
    ; Note, these assume the default hypertext type (same as wxHelp)
    (switch ?btype
     ; Large heading/section
     (case 5 then (hypertext-card-translator-output ?card -1 "</H2>"))
     (case 10 then (hypertext-card-translator-output ?card -1 "</H2>"))
     ; Small heading/section
     (case 6 then (hypertext-card-translator-output ?card -1 "</H3>"))
     (case 11 then (hypertext-card-translator-output ?card -1 "</H3>"))
     ; Italic or red italic
     (case 7 then (hypertext-card-translator-output ?card -1 "</I>"))
     (case 13 then (hypertext-card-translator-output ?card -1 "</I>"))
     ; Bold/red/blue/green
     (case 8 then (hypertext-card-translator-output ?card -1 "</B>"))
     (case 2 then (hypertext-card-translator-output ?card -1 "</B>"))
     (case 3 then (hypertext-card-translator-output ?card -1 "</B>"))
     (case 4 then (hypertext-card-translator-output ?card -1 "</B>"))
     ; Teletype
     (case 14 then (hypertext-card-translator-output ?card -1 "</TT>"))
    )

    ; Write end link, if there is one
    (trans-hypertext-card-write-link ?card ?blockid FALSE)
  )
  ;;; Start file
  (case 3 then (hypertext-card-translator-open-file ?card 1 ?*trans-hypertext-output-file*)
               (hypertext-card-translator-output ?card -1
                    (str-cat "<H1>" (card-get-string-attribute ?card "title") "</H1><P>" ?*nl*))
  )
  ;;; End file
  (case 4 then (hypertext-card-translator-close-file ?card 1)
               (hypertext-card-translator-close-file ?card 2)
  )
  ;;; Double new line (often means, end of paragraph)
  (case 5 then (hypertext-card-translator-output ?card -1 "<P>")
  )
 )
)

;;;
;;; Translate one hypertext card
;;;

(deffunction trans-translate-hypertext-card (?card)
 (trans-add-card ?card)
 (bind ?*block-type-stack* (mv-append))
 (bind ?*trans-hypertext-output-file* (str-cat ?*trans-output-path* "/" (trans-find-card-file ?card)))
 (hypertext-card-translate ?card trans-hypertext-card-translator)

 ;;; Now append any links from the Special Item
 (open ?*trans-hypertext-output-file* tempfile "a")
 (printout tempfile "<HR>" crlf)
 (trans-write-special-links ?card tempfile)
 (close tempfile)
)

; For reference: taken from wxhlpblk.h
; #define hyBLOCK_NORMAL                      1
; #define hyBLOCK_RED                         2
; #define hyBLOCK_BLUE                        3
; #define hyBLOCK_GREEN                       4
; #define hyBLOCK_LARGE_HEADING               5
; #define hyBLOCK_SMALL_HEADING               6
; #define hyBLOCK_ITALIC                      7
; #define hyBLOCK_BOLD                        8
; #define hyBLOCK_INVISIBLE_SECTION           9
; #define hyBLOCK_LARGE_VISIBLE_SECTION       10
; #define hyBLOCK_SMALL_VISIBLE_SECTION       11
; #define hyBLOCK_SMALL_TEXT                  12
; #define hyBLOCK_RED_ITALIC                  13
; #define hyBLOCK_TELETYPE                    14
