;;; dialog.clp
;;; Dialog for editing translator variables

;;; 'Local' globals
(defglobal
 ; Preferences
 ?*trans-preferences-box* = 0
 ?*trans-path-item* = 0
 ?*trans-actual-path-item* = 0
 ?*trans-root-item* = 0
 ?*trans-scale-item* = 0
 ?*trans-dialog-cancel* = 0

 ; Modeless dialog
 ?*trans-processing-dialog* = 0
 ?*trans-processing-message* = 0
)

;;; Respond to Ok button
(deffunction trans-dialog-ok (?but)
 (bind ?*trans-output-path* (text-get-value ?*trans-path-item*))
 (bind ?*trans-actual-path* (text-get-value ?*trans-actual-path-item*))
 (bind ?*trans-name-root* (text-get-value ?*trans-root-item*))
 (bind ?*trans-diagram-scale* (string-to-long (text-get-value ?*trans-scale-item*)))
 (window-show ?*trans-preferences-box* 0)
 (window-delete ?*trans-preferences-box*)
)

;;; Respond to Cancel button
(deffunction trans-dialog-cancel (?but)
 (bind ?*trans-dialog-cancel* 1)
 (window-show ?*trans-preferences-box* 0)
 (window-delete ?*trans-preferences-box*)
)

;;; Show the dialog
(deffunction trans-show-dialog ()
 (bind ?*trans-dialog-cancel* 0)
 (bind ?*trans-preferences-box* (dialog-box-create 0 "HTML Translation Preferences" 1 0 0 500 500))
 (panel-set-label-position ?*trans-preferences-box* wxVERTICAL)
 (bind ?*trans-path-item* (text-create ?*trans-preferences-box* "" "Destination directory" ?*trans-output-path* -1 -1 250))
 (panel-new-line ?*trans-preferences-box*)
 (bind ?*trans-actual-path-item* (text-create ?*trans-preferences-box* "" "Actual path to be used in HTML" ?*trans-actual-path* -1 -1 250))
 (panel-new-line ?*trans-preferences-box*)
 (bind ?*trans-root-item* (text-create ?*trans-preferences-box* "" "Filename root" ?*trans-name-root* -1 -1 250))
 (panel-new-line ?*trans-preferences-box*)
 (bind ?*trans-scale-item* (text-create ?*trans-preferences-box* "" "Diagram output width (in pixels)" (str-cat ?*trans-diagram-scale*) -1 -1 250))
 (panel-new-line ?*trans-preferences-box*)
 (bind ?ok-item (button-create ?*trans-preferences-box* trans-dialog-ok "OK"))
 (bind ?cancel-item (button-create ?*trans-preferences-box* trans-dialog-cancel "Cancel"))
 (panel-item-set-default ?ok-item)
 (window-fit ?*trans-preferences-box*)
 (window-centre ?*trans-preferences-box* wxBOTH)
 (window-show ?*trans-preferences-box* 1)
 (if (eq ?*trans-dialog-cancel* 1) then
   (return 0) else
   (return 1))
)

;;; Modeless dialog for informing user what's going on. Only shows
;;; under Windows, since X's synchronous nature means that nothing
;;; shows up until processing has ended.

(deffunction trans-show-processing-dialog ()
 (if (neq (get-platform ) "Windows 3.1") then (return))

 (bind ?*trans-processing-dialog* (dialog-box-create 0 "HTML Conversion" 0 10 10 400 80))
 (message-create ?*trans-processing-dialog* "Converting to HTML...")
 (panel-new-line ?*trans-processing-dialog*)
 (bind ?*trans-processing-message* (message-create ?*trans-processing-dialog* ""))
 (window-show ?*trans-processing-dialog* 1)
 (yield)
)

(deffunction trans-hide-processing-dialog ()
 (if (neq (get-platform ) "Windows 3.1") then (return))

 (window-show ?*trans-processing-dialog* 1)
 (window-delete ?*trans-processing-dialog*)
)

(deffunction trans-tell-processing (?msg)
 (if (neq (get-platform) "Windows 3.1") then (return))

 (panel-item-set-label ?*trans-processing-message* ?msg)
 (yield)
)

