;;; convert.clp
;;; Converts Hardy to HTML

;;; Translate a card
(deffunction trans-translate-card (?card)
 (bind ?card-type (card-get-string-attribute ?card "type"))
 (trans-tell-processing (card-get-string-attribute ?card "title"))
 (printout t "Processing card " (card-get-string-attribute ?card "title") crlf)
 (switch ?card-type
  (case "Diagram card" then (trans-translate-diagram-card ?card))
  (case "Diagram expansion" then (trans-translate-diagram-card ?card))
  (case "Text card" then (trans-translate-text-card ?card))
  (case "Hypertext card" then (trans-translate-hypertext-card ?card))
 )
 (card-quit ?card)
)

;;; Translate index (i.e. all cards)
(deffunction translate-index ()
  (unwatch all)
  (trans-reset-globals)

  ;;; Show the preferences dialog
  (bind ?ok (trans-show-dialog))
  (if (eq ?ok 0) then (return 0))

  (trans-show-processing-dialog)

  (bind ?card (get-first-card))
  (while (> ?card -1)
    (trans-translate-card ?card)
    (bind ?card (get-next-card))
  )
  (trans-tell-processing "Converting BMPs to GIFs")

  (if (> (length$ ?*trans-bitmap-file-list*) 0) then
   (trans-convert-files FALSE) ; Big (non-inline GIFs) with b appended to name
   (trans-convert-files TRUE)  ; inline GIFs
  )
  (message-box (str-cat "Translated Hardy index." ?*nl* "Press OK when GIFs have been translated." ?*nl*
     "This will delete the BMP files."))
  
  (trans-hide-processing-dialog)

  ;;; Delete all the BMP files
  (bind ?files ?*trans-bitmap-file-list*)
  (bind ?name (nth$ 1 ?files))
  (while (> (length$ ?files) 0)
   (remove (str-cat ?name ".bmp"))
   (bind ?files (rest$ ?files))
   (bind ?name (nth$ 1 ?files))
  )
  ; Remove gifs.lst
  (remove (str-cat ?*trans-output-path* "/gifs.lst"))
  (return 1)
)
