;;; Drag interception demo.

;;; Handler for the drag right from node to canvas
(deffunction drag-node-to-canvas (?card-id ?image-id ?attachment ?x ?y ?shift ?control)
 (declare ?attachment integer ?shift integer ?control integer)
 ; Create a node image
 (bind ?image1 (node-image-create ?card-id "Dummy Node"))
 (diagram-image-move ?card-id ?image1 ?x ?y)
 (bind ?image2 (arc-image-create ?card-id "Arc" ?image-id ?image1 0 0))
)

;;; Handler for the drag right from canvas to node
(deffunction drag-canvas-to-node (?card-id ?image-id ?attachment ?x ?y ?shift ?control)
 (declare ?attachment integer ?shift integer ?control integer)
 ; Create a node image
 (bind ?image1 (node-image-create ?card-id "Dummy Node"))
 (diagram-image-move ?card-id ?image1 ?x ?y)
 (bind ?image2 (arc-image-create ?card-id "Arc" ?image1 ?image-id 0 0))
)

;;; Handler for the drag right from canvas to canvas
(deffunction drag-canvas-to-canvas (?card-id ?x1 ?y1 ?x2 ?y2 ?shift ?control)
 (declare ?shift integer ?control integer)
 ; Create two node images
 (bind ?image1 (node-image-create ?card-id "Dummy Node"))
 (bind ?image2 (node-image-create ?card-id "Dummy Node"))
 (diagram-image-move ?card-id ?image1 ?x1 ?y1)
 (diagram-image-move ?card-id ?image2 ?x2 ?y2)
 (bind ?image3 (arc-image-create ?card-id "Arc" ?image1 ?image2 0 0))
)


