;;; ddeserv.clp
;;; Demo of DDE: server side.
;;; Should talk to a ddeclien.clp copy of wxCLIPS.
;;; Under Windows, you may need to copy wxclips.exe to wxclips2.exe
;;; to allow a second copy of wxCLIPS to run.
;;;

(defglobal ?*test-server* = 0)
(defglobal ?*test-server-name* = "DDETEST")
(defglobal ?*test-host-name* = "none")
(defglobal ?*test-topic-name* = "DDETEST")
(defglobal ?*test-connection* = 0)

; Callback to receive OnRequest events
(deffunction on-request (?connection-id ?type ?topic ?item ?data)
 (format t "Client requested topic %s, item %s%n" ?topic ?item)
 (return "Some data")
 )

; Callback to receive OnExecute events
(deffunction on-execute (?connection-id ?type ?topic ?item ?data)
 (format t "Client executed command: %s%n" ?data)
 (return 1)
 )

; Callback to accept or reject connections for this server
(deffunction on-accept-connection (?server-id ?topic ?connection-id)
 (format t "Accepting connection for topic %s%n" ?topic)
 (window-add-callback ?connection-id OnRequest on-request)
 (window-add-callback ?connection-id OnExecute on-execute)
 (return 1)
 )

;;; Automatically called when running application from command line
;;; e.g. wxclips -start -clips ddeclien.clp
;;; Also runnable from the Application: Run application.

(deffunction app-on-init ()
 (unwatch all)
 ; Create a server and add a callback.
 (bind ?*test-server* (server-create ?*test-server-name*))
 (window-add-callback ?*test-server* OnAcceptConnection on-accept-connection)
)

