;;; ddeclien.clp
;;; Demo of DDE: client side.
;;; Should talk to a ddeserv.clp copy of wxCLIPS.
;;; Under Windows, you may need to copy wxclips.exe to wxclips2.exe
;;; to allow a second copy of wxCLIPS to run.
;;;

(defglobal ?*test-server-name* = "DDETEST")
(defglobal ?*test-host-name* = "none")
(defglobal ?*test-topic-name* = "DDETEST")
(defglobal ?*test-client* = 0)
(defglobal ?*test-connection* = 0)

;;; Issues Execute and Request DDE commands
(deffunction test-demo ()
 ;; Get a command from the user
 (bind ?command-name (get-text-from-user "Data to execute (type in anything)"))
 (if (neq ?command-name "") then
  ;; Construct a client object
  (bind ?*test-client* (client-create))

  ;; Construct a connection object
  (bind ?*test-connection* (client-make-connection
              ?*test-client* ?*test-host-name*
              ?*test-server-name* ?*test-topic-name*))

  ;; Execute a command to create a group
  (bind ?exe (connection-execute ?*test-connection* ?command-name))

  ;; Request a data item
  (bind ?req (connection-request ?*test-connection* "DDETEST"))
  (format t "%nGot this back from the server:%n")
  (format t "%s%n%n" ?req)

  ;; Disconnect
  (connection-disconnect ?*test-connection*)
 )
)

;;; Automatically called when running application from command line
;;; e.g. wxclips -start -clips ddeclien.clp
;;; Also runnable from the Application: Run application.

(deffunction app-on-init ()
 (unwatch all)
 (test-demo)
)
