;;; utils.clp
;;; Utilities

;;; Finds a card label for the card id
(deffunction trans-find-card-label (?card-id)
 (bind ?pos (member$ ?card-id ?*trans-card-ids*))
 (if (eq ?pos FALSE)
   then (return "")
   else (return (nth$ ?pos ?*trans-card-labels*))
 )
)

;;; Finds a card HTML filename for the card id
(deffunction trans-find-card-file (?card-id)
 (bind ?pos (member$ ?card-id ?*trans-card-ids*))
 (if (eq ?pos FALSE)
   then (return "")
   else
    (return (nth$ ?pos ?*trans-card-files*))
 )
)

;;; Generates a suitable label and HTML filename for
;;; this card, if not already present.
(deffunction trans-add-card (?card-id)
 (if (neq "" (trans-find-card-label ?card-id))
  then
   (return 0)
  else
   (if (eq ?card-id (get-top-card))
     then (bind ?filename (str-cat ?*trans-name-root* ".html"))
     else (bind ?filename (str-cat ?*trans-name-root* ?*trans-file-id* ".html"))
          (bind ?*trans-file-id* (+ ?*trans-file-id* 1))
   )
   (bind ?*trans-card-labels* (mv-append ?*trans-card-labels* (gensym)))
   (bind ?*trans-card-files* (mv-append ?*trans-card-files* ?filename))
   (bind ?*trans-card-ids* (mv-append ?*trans-card-ids* ?card-id))
   (return 1)
 )
)

;;; Add a card to the processed list
(deffunction trans-add-processed (?card-id)
 (bind ?*trans-processed* (mv-append ?*trans-processed* ?card-id))
)

;;; Have we processed this card?
(deffunction trans-is-processed (?card-id)
 (if (not (member$ ?card-id ?*trans-processed*))
  then (return FALSE)
  else (return TRUE)
 )
)

;;; Write an HTML list of links to other cards from the special item
;;; (for links not from particular items on the card such as images
;;; or blocks).
;;; Returns the number of links found

(deffunction trans-write-special-links (?card ?file)
 (bind ?count 0)
 (bind ?itemid (card-get-special-item ?card))

 (bind ?linkid (item-get-first-link ?card ?itemid))
 (while (> ?linkid -1)
   (bind ?othercard (link-get-card-to ?linkid))
   (if (neq ?othercard ?card) then
    (trans-add-card ?othercard)
    (printout ?file (str-cat "<a href=\"" ?*trans-actual-path* "/" (trans-find-card-file ?othercard) "\">"))
    (printout ?file (card-get-string-attribute ?othercard "title"))
    (printout ?file (str-cat "</a><P>") crlf)
    (bind ?count (+ ?count 1))
   )
   (bind ?linkid (item-get-next-link))
 )
 (return ?count)
)

;;; Convert GIF files

(deffunction trans-convert-files (?inline)
 (bind ?filelist (str-cat ?*trans-output-path* "/gifs.lst"))
 (if ?inline
   then (bind ?command (str-cat ?*gif-converter* " -O -X" ?*trans-diagram-scale* " -G @" ?filelist))
   else (bind ?command (str-cat ?*gif-converter* " -O -G @" ?filelist))
 )
 (printout t "Command is: " ?command crlf)

 (open ?filelist gifs "w")

 (bind ?files ?*trans-bitmap-file-list*)

 (bind ?name (nth$ 1 ?files))
 (while (> (length$ ?files) 0)
  (printout gifs ?name ".bmp" crlf)
  (bind ?files (rest$ ?files))
  (bind ?name (nth$ 1 ?files))
 )
 (close gifs)
 (printout t ?command crlf)
 (execute ?command 1)

 ;;; If not inline, must rename GIF files
 (if (not ?inline)
   then
   (message-box "Press OK to rename large GIFs...")
   (bind ?files ?*trans-bitmap-file-list*)

   (bind ?name (nth$ 1 ?files))
   (while (> (length$ ?files) 0)
    (rename (str-cat ?name ".gif") (str-cat ?name "b.gif"))
    (bind ?files (rest$ ?files))
    (bind ?name (nth$ 1 ?files))
   )
 )
    
)
  
;;; Custom menu handler (toplevel Hardy window)
(deffunction trans-custom-menu (?menuitem)
  (if (eq ?menuitem "Translate to &HTML") then (translate-index)
  )
)
