;;; text.clp
;;; Converts text cards to HTML

;;; Copy from the text card's file into the new file.

(defmessage-handler MAIN::HtmlWriter copy-text (?card ?newfile)
 (bind ?cardfile (hardy-path-search (card-get-string-attribute ?card "filename")))
 (if (neq ?cardfile "") then
  (if (not (open ?cardfile oldfile "r")) then
   (bind ?msg (str-cat "Could not open file " ?cardfile))
   (message-box ?msg)
   (return 0)
  )
  (bind ?line (readline oldfile))
  (while (and (neq ?line EOF) (neq ?line FALSE))
   (printout ?newfile ?line)
   (if (eq ?line "") then (printout ?newfile "<P>"))
   (printout ?newfile crlf)
   (bind ?line (readline oldfile))
  )
  (close oldfile)
 )
)

;;;
;;; Translate a text card
;;;

(defmessage-handler MAIN::HtmlWriter translate-text-card (?card)
 (if (send ?self is-card-processed ?card) then
   (return TRUE))
   
 (send ?self add-card ?card)

 (bind ?filename (str-cat ?self:output-path "/" (send ?self find-card-file ?card)))
 (bind ?frame-filename (str-cat ?self:output-path "/card-" ?card "-frame.html"))

 ;;; Add a contents entry to the top level file
 (send ?self output-card-contents-entry toplevelstream (card-get-string-attribute ?card "title") (send ?self find-card-file ?card))
 (send ?self output-card-contents-entry toplevelframestream (card-get-string-attribute ?card "title") (str-cat "card-" ?card "-frame.html"))

 ;;; Open the HTML file
 (bind ?success (open ?filename tempfile "w"))
 (open ?frame-filename tempfile2 "w")
 (if (not ?success) then
   (printout t "Could not open file " ?filename crlf)
   (return)
 )

 ;;; Output the title
 (printout tempfile "<HTML>" crlf "<HEAD>" crlf)
 (printout tempfile "<TITLE>" (card-get-string-attribute ?card "title") "</TITLE>" crlf)
 (printout tempfile "</HEAD>" crlf)
 (send ?self output-body-tag tempfile "bg.gif")
 (printout tempfile "<CENTER>" crlf)
 (printout tempfile "<FONT SIZE=2><I>" crlf "<A HREF=top-level.html>Contents</A>")
 (printout tempfile " / <A HREF=help.html>Help</A>")
 (printout tempfile "</I><FONT SIZE=3><HR>" crlf crlf)
 (printout tempfile "<H2>" (card-get-string-attribute ?card "title") "</H2>" crlf crlf)
 (printout tempfile "</CENTER>" crlf)
 (printout tempfile "<HR>" crlf)
; (printout tempfile "<PRE>" crlf)
 ;;; Copy the text from the card into the new file
 (send ?self copy-text ?card tempfile)
; (printout tempfile "</PRE>" crlf)
 (printout tempfile crlf)

 ;;; Now append any links from the Special Item
 (printout tempfile "<HR>" crlf)
 (send ?self write-special-links ?card tempfile FALSE)
 (send ?self output-card-footer tempfile ?card)
 (close tempfile)

 ;;; NOW DO THE FRAME VERSION
 
 ;;; Output the title
 (printout tempfile2 "<HTML>" crlf "<HEAD>" crlf)
 (printout tempfile2 "<TITLE>" (card-get-string-attribute ?card "title") "</TITLE>" crlf)
 (printout tempfile2 "</HEAD>" crlf)
 (send ?self output-body-tag tempfile2 "bg-1.gif")
 (printout tempfile2 "<CENTER>" crlf)
 (printout tempfile2 "<FONT SIZE=2><I>" crlf "<A HREF=top-level-frame.html TARGET=topwindow>Contents</A>")
 (printout tempfile2 " / <A HREF=help.html TARGET=infowindow>Help</A> / <A HREF=card-" ?card "-links.html TARGET=infowindow>Links</A>" crlf)
 (printout tempfile2 "</I><FONT SIZE=3><HR>" crlf crlf)
 (printout tempfile2 "<H2>" (card-get-string-attribute ?card "title") "</H2>" crlf crlf)
 (printout tempfile2 "</CENTER>" crlf crlf)
; (printout tempfile2 "<PRE>" crlf)
 ;;; Copy the text from the card into the new file
 (send ?self copy-text ?card tempfile2)
; (printout tempfile2 "</PRE>" crlf)
 (printout tempfile2 "</BODY></HTML>" crlf)
 (close tempfile2)

 ;;; Generate card-N-links.html: list of card links for frame mode
 (open (str-cat ?self:output-path "/card-" ?card "-links.html") linksfile "w")
 (printout linksfile "<HTML>" crlf)
 (printout linksfile "<HEAD>" crlf)
 (printout linksfile "<TITLE>" (card-get-string-attribute ?card "title") "</TITLE>" crlf)
 (printout linksfile "</HEAD>" crlf crlf)

 (send ?self output-body-tag linksfile "bg-3.gif")
 (send ?self write-special-links ?card linksfile TRUE)

 (printout linksfile "</BODY></HTML>" crlf)
 (close linksfile)
)




