;;; htmlgen.clp
;;; HtmlWriter class declaration.

;;; HtmlWriter
;;; Class implementing HTML generation facilities.

(defclass MAIN::HtmlWriter (is-a USER)
	(role concrete)
        
        ;;; Title of report
	(slot title
		(create-accessor read-write)
		(visibility public)
		(type STRING)
		(default "Unnamed Report"))
        ;;; Author of report
	(slot author
		(create-accessor read-write)
		(visibility public)
		(type STRING)
		(default "Unknown author"))
        ;;; The top-level report file
        (slot top-level-file
		(create-accessor read-write)
		(visibility public)
		(type STRING)
		(default "top-level.html"))
        ;;; The output path
        (slot output-path
		(create-accessor read-write)
		(visibility public)
		(type STRING)
		(default "c:/html/test"))
        ;;; Path for source of 'standard' project files
        ;;; (e.g. Help file, GIF buttons)
        (slot standard-path
		(create-accessor read-write)
		(visibility public)
		(type STRING)
		(default "c:/hrdyhtml"))
        ;;; The root name for report files
        ;;; NOW OBSOLETE: separate directory for each report.
        (slot name-root
		(create-accessor read-write)
		(visibility public)
		(type STRING)
		(default "test"))
        ;;; List of bitmaps for this report (to convert/delete)
        (multislot bitmap-file-list
		(create-accessor read-write)
		(visibility public)
		(default (create$)))
        ;;; List of processed cards
        (multislot cards-processed
		(create-accessor read-write)
		(visibility public)
		(default (create$)))
        ;;; The name of the DOS GIF converter utility
        (slot gif-converter
		(create-accessor read-write)
		(visibility public)
		(type STRING)
		(default "cview.exe"))
        ;;; The attribute for all nodes/arcs which is nominated
        ;;; as the 'name' (may sometimes be called 'label')
        (slot name-attribute
       		(create-accessor read-write)
		(visibility public)
		(type STRING)
		(default "name"))
        ;;; A counter to increment, for generating filenames
        (slot file-id
       		(create-accessor read-write)
		(visibility public)
		(type INTEGER)
		(default 0))

        ;;; ------ Dialog box slots ------
        
        ;;; Preferences dialog box
        (slot preferences-dialog
       		(create-accessor read-write)
		(visibility public)
		(type INTEGER)
		(default 0))
        ;;; Path item
        (slot path-item
       		(create-accessor read-write)
		(visibility public)
		(type INTEGER)
		(default 0))
        ;;; Standard document path item
        (slot standard-item
       		(create-accessor read-write)
		(visibility public)
		(type INTEGER)
		(default 0))
        ;;; Title item
        (slot title-item
       		(create-accessor read-write)
		(visibility public)
		(type INTEGER)
		(default 0))
        ;;; Author item
        (slot author-item
       		(create-accessor read-write)
		(visibility public)
		(type INTEGER)
		(default 0))
        ;;; Assigned identifier attribute
        (slot name-item
       		(create-accessor read-write)
		(visibility public)
		(type INTEGER)
		(default 0))
        ;;; Diagram scale item
        (slot scale-item
       		(create-accessor read-write)
		(visibility public)
		(type INTEGER)
		(default 0))
        ;;; Processing notification dialog
        (slot processing-dialog
       		(create-accessor read-write)
		(visibility public)
		(type INTEGER)
		(default 0))
        ;;; Processing notification message item
        (slot processing-message
       		(create-accessor read-write)
		(visibility public)
		(type INTEGER)
		(default 0))
        ;;; Was dialog cancelled?
        (slot dialog-cancel
       		(create-accessor read-write)
		(visibility public)
		(type SYMBOL)
		(default FALSE))
)

;;; Reset slots for another report
(defmessage-handler MAIN::HtmlWriter reset ()
  (bind ?self:bitmap-file-list (create$))
  (bind ?self:cards-processed (create$))
  (bind ?self:file-id 0)
  (return TRUE)
)

;;; Add card to processed list
(defmessage-handler MAIN::HtmlWriter add-card (?id)
  (bind ?self:cards-processed (mv-append ?self:cards-processed ?id))
  (return TRUE)
)

;;; Has card been processed?
(defmessage-handler MAIN::HtmlWriter is-card-processed (?id)
  (if (eq FALSE (member ?id ?self:cards-processed)) then (return FALSE)
    else (return TRUE)
  )
)


