;;; diagram.clp
;;; Converts diagram cards to HTML

;;;
;;; Translate a diagram card
;;;

(defmessage-handler MAIN::HtmlWriter translate-diagram-card (?card)
 (if (send ?self is-card-processed ?card) then
   (return TRUE))
   
 (send ?self add-card ?card)
 (bind ?filename (str-cat ?self:output-path "/" (send ?self find-card-file ?card)))
 (bind ?frame-filename (str-cat ?self:output-path "/card-" ?card "-frame.html"))
 
 ;;; Add a contents entry to the top level files
 (send ?self output-card-contents-entry toplevelstream (card-get-string-attribute ?card "title") (str-cat "card-" ?card ".html"))
 (send ?self output-card-contents-entry toplevelframestream (card-get-string-attribute ?card "title") (str-cat "card-" ?card "-frame.html"))
 
 (bind ?diagram-help-link (send ?self find-diagram-help-node ?card))

 ;;; Open the HTML files (one for the normal, frameless card, another for when using frames)
 (open ?filename tempfile "w")
 (open ?frame-filename tempfile2 "w")

 ;;; Output the title
 (printout tempfile "<HTML>" crlf)
 (printout tempfile "<HEAD>" crlf)
 (printout tempfile "<TITLE>" (card-get-string-attribute ?card "title") "</TITLE>" crlf)
 (printout tempfile "</HEAD>" crlf crlf)

 (printout tempfile2 "<HTML>" crlf)
 (printout tempfile2 "<HEAD>" crlf)
 (printout tempfile2 "<TITLE>" (card-get-string-attribute ?card "title") "</TITLE>" crlf)
 (printout tempfile2 "</HEAD>" crlf crlf)

 (send ?self output-body-tag tempfile "bg.gif")
 (send ?self output-body-tag tempfile2 "bg-1.gif")

 (printout tempfile "<CENTER>" crlf)
 (printout tempfile "<FONT SIZE=2><I>" crlf "<A HREF=top-level.html>Contents</A>")

 ;;; Help specific to this diagram
 (if (neq 0 ?diagram-help-link) then
;   (printout tempfile " / <A HREF=card-" ?diagram-help-link ".html>About this diagram</A>")
   (printout tempfile " / <A HREF=card-" ?diagram-help-link ".html>About " (card-get-string-attribute ?card "title") "</A>")
 )

 (printout tempfile " / <A HREF=help.html>Help</A>")
 (printout tempfile crlf "</I><FONT SIZE=3><HR>" crlf crlf)
 (printout tempfile "<H2>" (card-get-string-attribute ?card "title") "</H2>" crlf crlf)
 (printout tempfile "</CENTER>" crlf)

 (printout tempfile2 "<CENTER>" crlf)
 (printout tempfile2 "<FONT SIZE=2><I>" crlf "<A HREF=top-level-frame.html TARGET=topwindow>Contents</A>")

 ;;; Help specific to this diagram
 (if (neq 0 ?diagram-help-link) then
;   (printout tempfile2 " / <A HREF=card-" ?diagram-help-link "-frame.html>About this diagram</A>")
   (printout tempfile2 " / <A HREF=card-" ?diagram-help-link "-frame.html>About " (card-get-string-attribute ?card "title") "</A>")
 )

 (printout tempfile2 " / <A HREF=help.html TARGET=infowindow>Help</A> / <A HREF=card-" ?card "-nodes.html TARGET=infowindow>" crlf)
 (printout tempfile2 "All nodes</A> / <A HREF=card-" ?card "-links.html TARGET=infowindow>Links</A>" crlf)
 (printout tempfile2 crlf "</I><FONT SIZE=3><HR>" crlf crlf)
 (printout tempfile2 "<H2>" (card-get-string-attribute ?card "title") "</H2>" crlf crlf)
 (printout tempfile2 "</CENTER>" crlf)
 
 ;;; Save a bitmap file and remember the name in order to convert to GIF later
 (bind ?bitmap-file-root (str-cat ?self:output-path "/diag" ?self:file-id))
 (bind ?gif-filename (str-cat "diag" ?self:file-id ".gif"))
 (bind ?self:file-id (+ ?self:file-id 1))
 (bind ?bitmap-filename (str-cat ?bitmap-file-root ".bmp"))
 (bind ?self:bitmap-file-list (mv-append ?self:bitmap-file-list ?bitmap-file-root))

 (diagram-card-save-bitmap ?card ?bitmap-filename)

 ;;; Generate the image map and links from it.
 (send ?self generate-diagram-map tempfile ?card ?gif-filename FALSE)
 (send ?self generate-diagram-map tempfile2 ?card ?gif-filename TRUE)

 ;;; Write links from nodes.
 (printout tempfile "<HR>" crlf)
; (printout tempfile "<CENTER><H3>Nodes for " (card-get-string-attribute ?card "title") "</H3></CENTER>" crlf)

 ;;; Output nodes, with possible links to other cards
 (printout tempfile "<CENTER>" crlf)
 (printout tempfile "<TABLE BORDER=1 CELLPADDING=2 CELLSPACING=2>" crlf)
 (printout tempfile "<TR><TD COLSPAN=3 ALIGN=CENTER><FONT SIZE=5>Nodes for " (card-get-string-attribute ?card "title")
   "</FONT></TD></TR>" crlf)
 (send ?self write-nodes-from-left ?card tempfile FALSE)
 (printout tempfile "</TABLE>" crlf)
 (printout tempfile "</CENTER>" crlf)

 ;;; Now append any links from the Special Item
 (printout tempfile "<HR>" crlf)
 (send ?self write-special-links ?card tempfile FALSE)
 
 (send ?self output-card-footer tempfile ?card)
 (printout tempfile2 "</BODY></HTML>" crlf)
 (close tempfile)
 (close tempfile2)
 
 ;;; Generate card-N-nodes.html: list of nodes for frame mode
 (open (str-cat ?self:output-path "/card-" ?card "-nodes.html") nodesfile "w")
 (printout nodesfile "<HTML>" crlf)
 (printout nodesfile "<HEAD>" crlf)
 (printout nodesfile "<TITLE>" (card-get-string-attribute ?card "title") "</TITLE>" crlf)
 (printout nodesfile "</HEAD>" crlf crlf)

 (send ?self output-body-tag nodesfile "bg-3.gif")

; (printout nodesfile "<CENTER><H3>Nodes for " (card-get-string-attribute ?card "title") "</H3></CENTER>" crlf)

 (printout nodesfile "<CENTER>" crlf)
 (printout nodesfile "<TABLE BORDER=1 CELLPADDING=2 CELLSPACING=2>" crlf)
 (printout nodesfile "<TR><TD COLSPAN=3 ALIGN=CENTER><FONT SIZE=5>Nodes for " (card-get-string-attribute ?card "title")
   "</FONT></TD></TR>" crlf)
 (send ?self write-nodes-from-left ?card nodesfile TRUE)
 (printout nodesfile "</TABLE>" crlf)
 (printout nodesfile "</CENTER>" crlf)
 
 (printout nodesfile "<HR><I><FONT SIZE=2>Back to <A HREF=card-" ?card "-frame.html TARGET=topwindow>" (card-get-string-attribute ?card "title") "</FONT></A></I>" crlf)

 (printout nodesfile "</BODY></HTML>" crlf)
 (close nodesfile)

 ;;; Generate card-N-links.html: list of card links for frame mode
 (open (str-cat ?self:output-path "/card-" ?card "-links.html") linksfile "w")
 (printout linksfile "<HTML>" crlf)
 (printout linksfile "<HEAD>" crlf)
 (printout linksfile "<TITLE>" (card-get-string-attribute ?card "title") "</TITLE>" crlf)
 (printout linksfile "</HEAD>" crlf crlf)

 (send ?self output-body-tag linksfile "bg-3.gif")
 (send ?self write-special-links ?card linksfile TRUE)

 (printout linksfile "</BODY></HTML>" crlf)
 (close linksfile)

)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Global variables
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defglobal 
  ?*leftmost-coordinate* = 10000
  ?*leftmost-node-image* = FALSE
  ?*node-images-written* = (mv-append)
  ?*to-list* = (mv-append)
  ?*from-list* = (mv-append)
  ?*expansion-cards* = (mv-append)
  ?*status-dialog* = 0
  ?*status-message* = 0
)


;;; Conversion from normal text to HTML-compatible text (e.g. ampersand conversion)
;;; No conversions as yet.

(defmessage-handler MAIN::HtmlWriter convert-to-html (?text)
 (return ?text)

 ;;; This ignored pro tem
 (bind ?out-string "")
 (bind ?len (length$ ?text))
 (bind ?i 1)
 (while (<= ?i ?len) do
  (bind ?char (sub-string ?i ?i ?text))
  (switch ?char
    (case "&" then
     (bind ?out-string (str-cat ?out-string "&"))
    )
    (case "%" then
     (bind ?out-string (str-cat ?out-string "%"))
    )
    (case "_" then
     (bind ?out-string (str-cat ?out-string "_"))
    )
    (case "$" then
     (bind ?out-string (str-cat ?out-string "$"))
    )
    (default 
     (bind ?out-string (str-cat ?out-string ?char))
    )
  )
  (bind ?i (+ ?i 1))
 )
 (return ?out-string)
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Main functions - the top level functions appear last
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Find-leftmost-etc works by checking coordinates of node IMAGES, since these
;; are specific to individual expansion cards, whereas nodes are not

(defmessage-handler MAIN::HtmlWriter find-leftmost-node-image-not-written (?card) 
  (bind ?*leftmost-coordinate* 10000)
  (bind ?*leftmost-node-image* FALSE)
  (bind ?node-image (get-first-card-node-image ?card))
  (while (neq ?node-image -1)
    (bind ?image-x (get-image-x ?card ?node-image))
    (if (and (or (< ?image-x ?*leftmost-coordinate*) 
  ;; If the image is to the left of the leftmost image found so far ...
                 (and (eq ?image-x ?*leftmost-coordinate*)
                      (bind ?image-y (get-image-y ?card ?node-image))
                      (< ?image-y (get-image-y ?card ?*leftmost-node-image*))
                 )
             )
  ;; ... or it is immediately above the leftmost image found so far ...
             (not (member ?node-image ?*node-images-written*))
  ;; ... and it hasn't already been written out ...
        )
     then (bind ?*leftmost-coordinate* ?image-x)
          (bind ?*leftmost-node-image* ?node-image)
    )
  ;; ... then instantiate it to be the leftmost so far.
    (bind ?node-image (get-next-card-node-image))
  )
  (return ?*leftmost-node-image*)          
)


;;; NOT REQUIRED
(defmessage-handler MAIN::HtmlWriter write-arcs (?card ?filename ?list)
  (yield)
  (bind ?counter 1)
  (bind ?length (length ?list))
  (while (<= ?counter ?length)  
    (bind ?arc (nth ?counter ?list))
    (bind ?name-attrib (get-first-object-attribute ?card ?arc))
    (if (eq ?name-attrib "type") 
     then (bind ?name-attrib (get-next-object-attribute))
    )    
    (bind ?arc-name (send ?self convert-to-html (get-object-string-attribute ?card ?arc ?name-attrib)))
    (if (neq ?arc-name "") ;; i.e. if the "name" attribute exists and is defined
     then (printout ?filename "<LI><I>" (send ?self convert-to-html ?arc-name) "</I>" crlf)
     else (printout ?filename "<LI><I>" Arc "</I>" crlf)
    )
    (printout ?filename "<UL>" crlf)
    (bind ?attribute (get-first-object-attribute ?card ?arc))
    (while (neq ?attribute "")
     (if  (neq ?attribute ?name-attrib)
      then    (printout ?filename "<LI><B>" ?attribute ":</B> "
               (send ?self convert-to-html (get-object-string-attribute ?card ?arc ?attribute)) crlf)
     )
     (bind ?attribute (get-next-object-attribute))
    )
    (printout ?filename "</UL>" crlf crlf)
    (bind ?counter (+ ?counter 1))
  )
)

;;; Write out nodes in left-to-right order as they appear in the diagram.
(defmessage-handler MAIN::HtmlWriter write-nodes-from-left (?card ?filename ?is-frame)
  (bind ?node-image (send ?self find-leftmost-node-image-not-written ?card))
  (while (neq ?node-image FALSE)
    (bind ?*node-images-written* (mv-append ?node-image ?*node-images-written*))

    (if (not (send ?self is-diagram-comment ?card ?node-image)) then

      (bind ?node (get-object-from-image ?card ?node-image))
      (send ?self note-expansion-cards ?card ?node-image)
      (bind ?node-name (send ?self convert-to-html (get-object-string-attribute ?card ?node ?self:name-attribute)))
      (if (neq ?node-name "") ;; i.e. if the nominated "name/id/label" attribute exists and is defined
       then (bind ?principal-name ?node-name)
       else (bind ?principal-name "Node")
      )
      (printout ?filename "<TR>" crlf "<TD WIDTH=200>")
      (printout ?filename ?principal-name)
      (printout ?filename "</TD> <TD>")
    
      ;;; Write pointer to node attributes card
      (printout ?filename "<A HREF=\"node-details-" ?card "-" ?node-image ".html\" TARGET=infowindow>details</A></TD> <TD> ")

      ;;; Write pointer to expansion card, if any.
    
      (bind ?exp-id (send ?self diagram-output-link ?filename ?card ?node-image TRUE ?is-frame)) ; Possibly a start href
      (if (neq ?exp-id -1)
        then
          (printout ?filename (card-get-string-attribute ?exp-id "title"))
          (send ?self diagram-output-link ?filename ?card ?node-image FALSE ?is-frame) ; Possibly an end href
      else
        (printout ?filename "No expansion")
      )
      (printout ?filename "</TD></TR>" crlf crlf)
    )

    (bind ?node-image (send ?self find-leftmost-node-image-not-written ?card))
  )
;  (printout ?filename "</TABLE>" crlf)
  (bind ?*node-images-written* (mv-append))
)  

;;; Outputs an HTML link from this image, if any, returning the card id or -1
(defmessage-handler MAIN::HtmlWriter diagram-output-link (?file ?card ?node-image ?start ?is-frame)
 (bind ?itemid (diagram-image-get-item ?card ?node-image))
 (if (> ?itemid -1) then
   (bind ?linkid (item-get-first-link ?card ?itemid))
   (if (> ?linkid -1) then
     (bind ?othercard (link-get-card-to ?linkid))
     (if (neq ?othercard ?card) then
      (if ?start then
        
        (if (eq ?is-frame TRUE) then
          (printout ?file
           (str-cat "<a href=card-" ?othercard "-frame.html TARGET=topwindow>"))
         else
          (printout ?file
           (str-cat "<a href=" (send ?self find-card-file ?othercard) " TARGET=topwindow>"))
        )
        else
        (printout ?file "</a>")
      )
      (return ?othercard)
     )
    )
  )
 (return -1)
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Utility functions
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Is this node image just an "About this diagram" comment?
(defmessage-handler MAIN::HtmlWriter is-diagram-comment (?card ?node-image)
  (bind ?id-attribute (send ?self get-name-attribute))

  (bind ?node-object (diagram-image-get-object ?card ?node-image))
  (bind ?text (diagram-object-get-string-attribute ?card ?node-object ?id-attribute))
  (if (eq ?text "About this diagram") then (return TRUE)
    else (return FALSE)
  )
)


;; This function makes sure expansion cards are written out in the same order
;; as the nodes in the diagram

(defmessage-handler MAIN::HtmlWriter note-expansion-cards (?card ?node-image)  
  (bind ?expansion (get-first-image-expansion ?card ?node-image))
  (while (neq ?expansion -1)
    (bind ?*expansion-cards* (mv-append ?*expansion-cards* ?expansion))
    (bind ?expansion (get-next-image-expansion))
  )
)

(defmessage-handler MAIN::HtmlWriter find-arc-from-id (?card ?id)
  (bind ?arc (get-first-card-arc ?card))
  (while (neq ?arc -1)
    (if (eq ?id ?arc)
     then (return ?arc)
     else (bind ?arc (get-next-card-arc))
    )
  )
  (return FALSE) ;; arc not found
)

;;; Check if there's a node image called "About this diagram".
;;; If so, we can add it to the button bar.
(defmessage-handler MAIN::HtmlWriter find-diagram-help-node (?card)

  (bind ?the-node-image 0)
  
  (bind ?node-image (get-first-card-node-image ?card))
  (bind ?id-attribute (send ?self get-name-attribute))
  (while (neq ?node-image -1)

    (bind ?node-object (diagram-image-get-object ?card ?node-image))
    (bind ?text (diagram-object-get-string-attribute ?card ?node-object ?id-attribute))
    (if (eq ?text "About this diagram") then
      (bind ?the-node-image ?node-image)
      (bind ?node-image -1)
     else
     (bind ?node-image (get-next-card-node-image))
    )
  )
  
  (if (eq ?the-node-image 0) then (return 0))
  
  ;;; Now find the first card linked to this node
  (bind ?item (diagram-image-get-item ?card ?the-node-image))
  
  (if (or (eq ?item 0) (eq ?item -1)) then (return 0))
  
  (bind ?link (item-get-first-link ?card ?item))
  (if (neq ?link -1) then
    (return (link-get-card-to ?link)))
    
  (return 0)
)
    
  
