;;; This function check for exclusive existence of the arc annotation.
;;; exclusive is the set of annotations that cannot be co-existed.
;;; e.g., ("Many" "Optional" "One or more")  this is the
;;; exclusiveness of the multiplicity information of the OMT association.
;;; This function takes region into consideration if ?region-name is
;;; not equal to NULL, i.e., exclusiveness occurs
;;; at the specified region.  For example, although elements of the multiplicity
;;; information cannot co-exist at one end of the arc, they can co-exist if 
;;; "One" is at the start and "Many" is at the end of the arc.
;;;
;;; This function returns 1 if this is the first annotation added.
;;; This function returns the already existed annotation-id if selective annotation does not conflict
;;; with any existing annotations of the arc at a particular region.
;;; Otherwise returns 0
;;;
;;; Note that in order to be able to use CLIPS2C to provide the C function we want, we
;;; have compromise the program here.  Instead of passing the set of elements as a list
;;; and use the set member checking function in CLIPS to check the existence of the element,
;;; I have to define the member checking in a clumsy way...
;;; ?exclusive is the flag that tells which set of element supposed to be checked...
(deffunction omt-multiplicity (?annotation-name)
	(if (or (eq ?annotation-name "Many") (eq ?annotation-name "Optional") (eq ?annotation-name "One or more")) then
		(bind ?res 1)
	else
		(bind ?res 0)
	)
	(return ?res)
)

(deffunction booch-multiplicity (?annotation-name)
	(if (or (eq ?annotation-name "Many") (eq ?annotation-name "One")) then
		(bind ?res 1)
	else
		(bind ?res 0)
	)
	(return ?res)
)

(deffunction booch-export (?annotation-name)
	(if (or (eq ?annotation-name "Protected") (eq ?annotation-name "Private")
		(eq ?annotation-name "Implementation") (eq ?annotation-name "One bar")
		(eq ?annotation-name "Two Bars") (eq ?annotation-name "Three Bars")) then
		(bind ?res 1)
	else
		(bind ?res 0)
	)
	(return ?res)
)

(deffunction booch-vrhu (?annotation-name)
	(if (or (eq ?annotation-name "By reference") (eq ?annotation-name "By value")
		(eq ?annotation-name "Has") (eq ?annotation-name "Using")) then
		(bind ?res 1)
	else
		(bind ?res 0)
	)
	(return ?res)
)

(deffunction booch-property-fs (?annotation-name)
	(if (or (eq ?annotation-name "F for Friend") (eq ?annotation-name "S for Static")) then
		(bind ?res 1)
	else
		(bind ?res 0)
	)
	(return ?res)
)


(deffunction booch-vr (?annotation-name)
	(if (or (eq ?annotation-name "By value") (eq ?annotation-name "By reference")) then
		(bind ?res 1)
	else
		(bind ?res 0)
	)
	(return ?res)
)       

(deffunction booch-hu (?annotation-name)
	(if (or (eq ?annotation-name "Has") (eq ?annotation-name "Using")) then
		(bind ?res 1)
	else
		(bind ?res 0)
	)
	(return ?res)
)       

(deffunction booch-visibility (?annotation-name)
	(if (or (eq ?annotation-name "Parameter") (eq ?annotation-name "Global")
		(eq ?annotation-name "Field") (eq ?annotation-name "Local")) then
		(bind ?res 1)
	else
		(bind ?res 0)
	)
	(return ?res)
)       
;;; 
;;; 1 - OMT Multiplicity
;;; 2 - Booch Multiplicity
;;; 3 - Booch export
;;; 4 - Booch vrhu
;;; 5 - Booch property Friend and Static
;;; 6 - Booch visibility
;;; 7 - Booch vr
;;; 8 - Booch hu
(deffunction check-for-membership (?exclusive ?annotation-name)
	(declare ?exclusive INTEGER)
	(bind ?res 0)
	(switch ?exclusive
		(case   1 then
			(bind ?res (omt-multiplicity ?annotation-name))
		)
		(case   2 then
			(bind ?res (booch-multiplicity ?annotation-name))
		)
		(case   3 then
			(bind ?res (booch-export ?annotation-name))
		)
		(case   4 then
			(bind ?res (booch-vrhu ?annotation-name))
		)
		(case   5 then
			(bind ?res (booch-property-fs ?annotation-name))
		)
		(case   6 then
			(bind ?res (booch-visibility ?annotation-name))
		)
		(case   7 then
			(bind ?res (booch-vr ?annotation-name))
		)
		(case   8 then
			(bind ?res (booch-hu ?annotation-name))
		)
	)
	(return ?res)
)

(deffunction check-for-exclusive-arc (?exclusive ?card-id ?arc-image-id ?annotation-id ?annotation-name ?region-name)
	(declare ?annotation-name STRING)
	(declare ?exclusive INTEGER)
	(bind ?ret 0)
	(bind ?member-1 ?annotation-name)
	(declare ?member-1 STRING)
	;;; for each already existed annotation at that region, check whether it is in the exclusive set ...
	(bind ?this-annotation-id (diagram-image-get-first-annotation ?card-id ?arc-image-id))
	;;; obtain the number of annotation already in the arc, this is used to check whether we are adding
	;;; the ever first one ...
	(bind ?no-of-annotation 0)
	(while (neq ?this-annotation-id -1)
		(bind ?no-of-annotation (+ ?no-of-annotation 1))
		(bind ?this-annotation-id (diagram-image-get-next-annotation))
	)
	;;; the almost entered one will be returned from get-first, so if there is only one
	;;; item, there is no existing one and we just add it ...
	(if (eq ?no-of-annotation 1) then
		(bind ?ret 1)
	)
	;;; starts from the beginning ...
	(if (neq ?ret 1) then
		(bind ?this-annotation-id (diagram-image-get-first-annotation ?card-id ?arc-image-id))
		(bind ?finish 0)
		(while (and (neq ?this-annotation-id -1) (neq ?finish 1))
			;;; if region-name is not null, then we need to be region-specific ...
			(bind ?region-check TRUE)
			(if (neq ?region-name "") then
				(bind ?this-annotation-region (diagram-image-annotation-get-drop-site ?card-id ?arc-image-id ?this-annotation-id))
				(if (eq ?this-annotation-region ?region-name) then
					(bind ?region-check TRUE)
				else
					(bind ?region-check FALSE)
				)
			)
			(if (eq ?region-check TRUE) then
				(bind ?this-annotation-type (diagram-image-annotation-get-logical-name ?card-id ?arc-image-id ?this-annotation-id))
				(declare ?this-annotation-type STRING)
				(bind ?member-2 ?this-annotation-type)
				(declare ?member-2 STRING)
				(bind ?res1 (check-for-membership ?exclusive ?member-1))
				(bind ?res2 (check-for-membership ?exclusive ?member-2))
				(if (and (neq ?annotation-id ?this-annotation-id) (eq ?res1 1) (eq ?res2 1)) then
					;;; replace the existing one with the newly added one
					;;;(diagram-image-delete-annotation ?card-id ?arc-image-id ?this-annotation-id)
					(bind ?ret ?this-annotation-id)
					(bind ?finish 1)
				)
			)
			(bind ?this-annotation-id (diagram-image-get-next-annotation))
		)
	)
	(return ?ret)
)       
	

;;; To draw the image
;;; Handler for the drag right from canvas to node
(deffunction drag-canvas-to-node (?card-id ?image-id ?attachment ?x ?y ?valid-node-type ?new-arc-type)
	; check the node type is an object
	(declare ?attachment STRING)
	(bind ?node1 (diagram-image-get-object ?card-id ?image-id ))
	(bind ?nodetype1 (diagram-object-get-string-attribute ?card-id ?node1 "type"))
	(if (eq ?nodetype1 ?valid-node-type) then
		; check the current selected arc type in the palette
		(bind ?arc-type1 (diagram-palette-get-arc-selection ?card-id))
		( if (eq ?arc-type1 ?new-arc-type ) then
			(bind ?image1 (node-image-create ?card-id "Invisible Node"))
			(diagram-image-move ?card-id ?image1 ?x ?y)
			(arc-image-create ?card-id ?new-arc-type ?image1 ?image-id 0 0)         
		)
	)
)


;;; Handle for the drag from an object to nothing...
(deffunction drag-node-to-canvas (?card-id ?image-id ?attachment ?x ?y ?valid-node-type ?new-arc-type)
	; check the node type is an object
	(declare ?attachment STRING)
	(bind ?node1 (diagram-image-get-object ?card-id ?image-id ))
	(bind ?nodetype1 (diagram-object-get-string-attribute ?card-id ?node1 "type"))
	(if (eq ?nodetype1 ?valid-node-type) then
		; check the current selected arc type in the palette
		(bind ?arc-type1 (diagram-palette-get-arc-selection ?card-id))
		( if (eq ?arc-type1 ?new-arc-type ) then
			(bind ?image1 (node-image-create ?card-id "Invisible Node"))
			(diagram-image-move ?card-id ?image1 ?x ?y)
			(arc-image-create ?card-id ?new-arc-type ?image-id ?image1 0 0)         
		)
	)
)
