;;; This function checks for the mutually exclusiveness of
;;; a set of annotations.
;;; exclusive for the following ...
;;; (One, Many)
;;; (Protected, Private, Implementation)
;;; (By reference, By value)
;;; (Using, Has)
;;;
(deffunction check-for-multiplicity (?card-id ?arc-image-id ?annotation-id ?annotation-name ?region-name)
	(declare ?annotation-id INTEGER)
	(declare ?annotation-name STRING)
	(declare ?region-name STRING)
	(bind ?exclusive 2)        
	(bind ?this-annotation-id (check-for-exclusive-arc ?exclusive ?card-id ?arc-image-id ?annotation-id ?annotation-name ?region-name))
	;;; delete any existing one if there exsits a conflict element ...
	(if (> ?this-annotation-id 1) then
		(diagram-image-delete-annotation ?card-id ?arc-image-id ?this-annotation-id)
	)
	(return 1)
)

(deffunction check-for-export (?card-id ?arc-image-id ?annotation-id ?annotation-name ?region-name)
	(declare ?annotation-id INTEGER)
	(declare ?annotation-name STRING)
	(bind ?exclusive 3)
	(bind ?region-name "")
	(bind ?this-annotation-id (check-for-exclusive-arc ?exclusive ?card-id ?arc-image-id ?annotation-id ?annotation-name ?region-name))
	;;; delete any existing one if there exsits a conflict element ...
	(if (> ?this-annotation-id 1) then
		(diagram-image-delete-annotation ?card-id ?arc-image-id ?this-annotation-id)
	)
	(return 1)
)


;;; check for using, has, by reference and by value ...
;;; Here is more completed.  Basically we want the following:
;;;
;;; The abbrevation used are v-by value, r-by reference, h-Has, u-using
;;;
;;; before insertion    after insertion
;;; start       end             start           end
;;; nothing     nothing         anything        anything
;;; (v, r)      nothing         anything        (h, u)
;;; (nothing)   (v, r)          (h, u)          anything
;;; (h, u)      nothing         anything        (v, r)
;;; nothing     (h, u)          (v, r)          anything
;;; (v, r)      (h, u)          (v, r)          (h, u)
;;; (h, u)      (v, r)          (h, u)          (v, r)
;;;
;;; error message will be displayed if illegal annotation is selected to
;;; add at illegal end. 
;;;
;;; check for has and using specifically...
(deffunction start-is-vr (?card-id ?arc-image-id ?annotation-id)
	(declare ?card-id INTEGER)
	(declare ?arc-image-id INTEGER)
	(declare ?annotation-id INTEGER)
	(bind ?exclusive 7)  
	(bind ?region-name "Start")
	(bind ?this-annotation-id (check-for-exclusive-arc ?exclusive ?card-id ?arc-image-id ?annotation-id "By value" ?region-name))
	(bind ?that-annotation-id (check-for-exclusive-arc ?exclusive ?card-id ?arc-image-id ?annotation-id "By reference" ?region-name))
	(if (or (> ?this-annotation-id 1) (> ?that-annotation-id 1)) then
		(return 1)
	 else
		(return 0)
	)
)

(deffunction end-is-vr (?card-id ?arc-image-id ?annotation-id)
	(declare ?card-id INTEGER)
	(declare ?arc-image-id INTEGER)
	(declare ?annotation-id INTEGER)
	(bind ?exclusive 7)   
	(bind ?region-name "End")
	(bind ?this-annotation-id (check-for-exclusive-arc ?exclusive ?card-id ?arc-image-id ?annotation-id "By-value" ?region-name))
	(bind ?that-annotation-id (check-for-exclusive-arc ?exclusive ?card-id ?arc-image-id ?annotation-id "By reference" ?region-name))
	(if (or (> ?this-annotation-id 1) (> ?that-annotation-id 1)) then
		(return 1)
	 else
		(return 0)
	)
)

(deffunction start-is-hu (?card-id ?arc-image-id ?annotation-id)
	(declare ?card-id INTEGER)
	(declare ?arc-image-id INTEGER)
	(declare ?annotation-id INTEGER)
	(bind ?exclusive 8)       
	(bind ?region-name "Start")
	(bind ?this-annotation-id (check-for-exclusive-arc ?exclusive ?card-id ?arc-image-id ?annotation-id "Has" ?region-name))
	(bind ?that-annotation-id (check-for-exclusive-arc ?exclusive ?card-id ?arc-image-id ?annotation-id "Using" ?region-name))
	(if (or (> ?this-annotation-id 1) (> ?that-annotation-id 1)) then
		(return 1)
	 else
		(return 0)
	)
)

(deffunction end-is-hu (?card-id ?arc-image-id ?annotation-id)
	(declare ?card-id INTEGER)
	(declare ?arc-image-id INTEGER)
	(declare ?annotation-id INTEGER)
	(bind ?exclusive 8)       
	(bind ?region-name "End")
	(bind ?this-annotation-id (check-for-exclusive-arc ?exclusive ?card-id ?arc-image-id ?annotation-id "Has" ?region-name))
	(bind ?that-annotation-id (check-for-exclusive-arc ?exclusive ?card-id ?arc-image-id ?annotation-id "Using" ?region-name))
	(if (or (> ?this-annotation-id 1) (> ?that-annotation-id 1)) then
		(return 1)
	 else
		(return 0)
	)
)
	
;;; check there is no existence of h, u, v or r...
(deffunction start-is-nothing (?card-id ?arc-image-id ?annotation-id )
	(declare ?card-id INTEGER)
	(declare ?arc-image-id INTEGER)
	(declare ?annotation-id INTEGER)
	(bind ?res (start-is-hu ?card-id ?arc-image-id ?annotation-id ))
	(bind ?res1 (start-is-vr ?card-id ?arc-image-id ?annotation-id ))
	(if (and (neq ?res 1) (neq ?res1 1)) then
		(return 1)
	else
		(return 0)
	)
)


(deffunction end-is-nothing (?card-id ?arc-image-id ?annotation-id )
	(declare ?card-id INTEGER)
	(declare ?arc-image-id INTEGER)
	(declare ?annotation-id INTEGER)
	(bind ?res2 (end-is-hu ?card-id ?arc-image-id ?annotation-id ))
	(bind ?res3 (end-is-vr ?card-id ?arc-image-id ?annotation-id ))
	(if (and (neq ?res2 1) (neq ?res3 1)) then
		(return 1)
	else
		(return 0)
	)
)

;;; Case 1: this check for condition in which anything can add ...
(deffunction check-for-hurv (?card-id ?arc-image-id ?annotation-id )
	(declare ?card-id INTEGER)
	(declare ?arc-image-id INTEGER)
	(declare ?annotation-id INTEGER)
	;;; Just add it for the following situations ...
	(bind ?a (start-is-nothing ?card-id ?arc-image-id ?annotation-id ))
	(bind ?b (end-is-nothing ?card-id ?arc-image-id ?annotation-id ))
	(if (and (eq ?a 1) 
		 (eq ?b 1)) then
		(return 1)
	)

)


;;; Case 2:
(deffunction case-2 (?card-id ?arc-image-id ?annotation-id )
	(declare ?card-id INTEGER)
	(declare ?arc-image-id INTEGER)
	(declare ?annotation-id INTEGER)
	(bind ?a (start-is-vr ?card-id ?arc-image-id ?annotation-id ))
	(bind ?b (end-is-nothing ?card-id ?arc-image-id ?annotation-id ))
	(if (and (eq ?a 1) (eq ?b 1)) then 
		(return 1)
	else
		(return 0)
	)
)


;;; Case 3:
(deffunction case-3 (?card-id ?arc-image-id ?annotation-id )
	(declare ?card-id INTEGER)
	(declare ?arc-image-id INTEGER)
	(declare ?annotation-id INTEGER)
	(bind ?a (start-is-nothing ?card-id ?arc-image-id ?annotation-id ))
	(bind ?b (end-is-vr ?card-id ?arc-image-id ?annotation-id ))
	(if (and (eq ?a 1) (eq ?b 1)) then
		(return 1)
	else
		(return 0)
	)
)
		
;;; Case 4:
(deffunction case-4 (?card-id ?arc-image-id ?annotation-id )
	(declare ?card-id INTEGER)
	(declare ?arc-image-id INTEGER)
	(declare ?annotation-id INTEGER)
	(bind ?a (start-is-hu ?card-id ?arc-image-id ?annotation-id ))
	(bind ?b (end-is-nothing ?card-id ?arc-image-id ?annotation-id ))
	(if (and (eq ?a 1) (eq ?b 1)) then
		(return 1)
	else
		(return 0)
	)
)

;;; Case 5:
(deffunction case-5 (?card-id ?arc-image-id ?annotation-id )
	(declare ?card-id INTEGER)
	(declare ?arc-image-id INTEGER)
	(declare ?annotation-id INTEGER)
	(bind ?a (start-is-nothing ?card-id ?arc-image-id ?annotation-id ))
	(bind ?b (end-is-hu ?card-id ?arc-image-id ?annotation-id ))    
	(if (and (eq ?a 1) (eq ?b 1)) then
		(return 1)
	else
		(return 0)
	)
)       


;;; Case 6
(deffunction case-6 (?card-id ?arc-image-id ?annotation-id  )
	(declare ?card-id INTEGER)
	(declare ?arc-image-id INTEGER)
	(declare ?annotation-id INTEGER)
	(bind ?a (start-is-vr ?card-id ?arc-image-id ?annotation-id ))
	(bind ?b (end-is-hu ?card-id ?arc-image-id ?annotation-id ))    
	(if (and (eq ?a 1) (eq ?b 1)) then
		(return 1)
	else
		(return 0)
	)
)       

;;; Case 7:
(deffunction case-7 (?card-id ?arc-image-id ?annotation-id )
	(declare ?card-id INTEGER)
	(declare ?arc-image-id INTEGER)
	(declare ?annotation-id INTEGER)
	(bind ?a (start-is-hu ?card-id ?arc-image-id ?annotation-id ))
	(bind ?b (end-is-vr ?card-id ?arc-image-id ?annotation-id ))    
	(if (and (eq ?a 1) (eq ?b 1)) then
		(return 1)
	else
		(return 0)
	)
)       



(deffunction check-for-hu (?card-id ?arc-image-id ?annotation-id ?annotation-name ?region-name )
	(declare ?annotation-name STRING)
	(declare ?annotation-id INTEGER)
	(bind ?all-for (check-for-hurv ?card-id ?arc-image-id ?annotation-id ) )
	(if (eq ?all-for 1) then
		(return 1)
	)
	;;;
	(if (eq ?region-name "Start") then
		(bind ?is-case-3 (case-3 ?card-id ?arc-image-id ?annotation-id ) )
		(bind ?is-case-7 (case-7 ?card-id ?arc-image-id ?annotation-id ) )
		(bind ?is-case-2 (case-2 ?card-id ?arc-image-id ?annotation-id ) )
		(bind ?is-case-4 (case-4 ?card-id ?arc-image-id ?annotation-id ) )
		(if (or (eq ?is-case-3 1) (eq ?is-case-7 1) (eq ?is-case-2 1) (eq ?is-case-4 1) ) then
			;;; delete image and replace
			(bind ?exclusive 4)
			(bind ?this-annotation-id (check-for-exclusive-arc ?exclusive ?card-id ?arc-image-id ?annotation-id ?annotation-name ?region-name))
			;;; delete any existing one if there exsits a conflict element ...
			(if (> ?this-annotation-id 1) then
				(diagram-image-delete-annotation ?card-id ?arc-image-id ?this-annotation-id)
			)
			(return 1)
		)
	)
	;;;
	(if (eq ?region-name "End") then
		(bind ?is-case-2 (case-2 ?card-id ?arc-image-id ?annotation-id ) )
		(bind ?is-case-6 (case-6 ?card-id ?arc-image-id ?annotation-id ) )
		(bind ?is-case-3 (case-3 ?card-id ?arc-image-id ?annotation-id ) )
		(bind ?is-case-5 (case-5 ?card-id ?arc-image-id ?annotation-id ) )
		(if (or (eq ?is-case-2 1 ) (eq ?is-case-6 1) (eq ?is-case-3 1 ) (eq ?is-case-5 1)) then         
			;;; delete image and replace
			(bind ?exclusive 4)
			(bind ?this-annotation-id (check-for-exclusive-arc ?exclusive ?card-id ?arc-image-id ?annotation-id ?annotation-name ?region-name))
			;;; delete any existing one if there exsits a conflict element ...
			(if (> ?this-annotation-id 1) then
				(diagram-image-delete-annotation ?card-id ?arc-image-id ?this-annotation-id)
			)
			(return 1)
		)

	)
	(return 0)
)


(deffunction check-for-vr  (?card-id ?arc-image-id ?annotation-id ?annotation-name ?region-name)
	(declare ?annotation-name STRING)
	(bind ?all-for (check-for-hurv ?card-id ?arc-image-id ?annotation-id ) )
	(if (eq ?all-for 1) then
		(return 1)
	)
	;;;
	(if (eq ?region-name "Start") then
		(bind ?is-case-5 (case-5 ?card-id ?arc-image-id ?annotation-id ) )
		(bind ?is-case-6 (case-6 ?card-id ?arc-image-id ?annotation-id  ) )
		(bind ?is-case-2 (case-2 ?card-id ?arc-image-id ?annotation-id ) )
		(bind ?is-case-4 (case-4 ?card-id ?arc-image-id ?annotation-id ) )
		(if (or (eq ?is-case-5 1) (eq ?is-case-6 1) (eq ?is-case-2 1) (eq ?is-case-4 1) ) then
			;;; delete image and replace
			(bind ?exclusive 4)
			(bind ?this-annotation-id (check-for-exclusive-arc ?exclusive ?card-id ?arc-image-id ?annotation-id ?annotation-name ?region-name))
			;;; delete any existing one if there exsits a conflict element ...
			(if (> ?this-annotation-id 1) then
				(diagram-image-delete-annotation ?card-id ?arc-image-id ?this-annotation-id)
			)
			(return 1)
		)
	)
	;;;
	(if (eq ?region-name "End") then
		(bind ?is-case-4 (case-4 ?card-id ?arc-image-id ?annotation-id ) )
		(bind ?is-case-7 (case-7 ?card-id ?arc-image-id ?annotation-id ) )
		(bind ?is-case-3 (case-3 ?card-id ?arc-image-id ?annotation-id ) )
		(bind ?is-case-5 (case-5 ?card-id ?arc-image-id ?annotation-id ) )      
		(if (or (eq ?is-case-4 1) (eq ?is-case-7 1) (eq ?is-case-3 1) (eq ?is-case-5 1)) then           
			;;; delete image and replace
			(bind ?exclusive 4 )
			(bind ?this-annotation-id (check-for-exclusive-arc ?exclusive ?card-id ?arc-image-id ?annotation-id ?annotation-name ?region-name))
			;;; delete any existing one if there exsits a conflict element ...
			(if (> ?this-annotation-id 1) then
				(diagram-image-delete-annotation ?card-id ?arc-image-id ?this-annotation-id)
			)
			(return 1)
		)

	)
	(return 0)
)
	
;;; check for static, friend ...
(deffunction check-for-properties (?card-id ?arc-image-id ?annotation-id ?annotation-name ?region-name)
	(declare ?annotation-id INTEGER)
	(declare ?annotation-name STRING)
	(declare ?region-name STRING)
	;;; NEED TO BE UPDATED WHEN HARDY IS FIXED ...
	(bind ?exclusive 5 )
	(bind ?this-annotation-id (check-for-exclusive-arc ?exclusive ?card-id ?arc-image-id ?annotation-id ?annotation-name ""))
	;;; delete any existing one if there exsits a conflict element ...
	(if (> ?this-annotation-id 1) then
		(diagram-image-delete-annotation ?card-id ?arc-image-id ?this-annotation-id)
	)
	(return 1)
)       



(deffunction validate-association (?card-id ?arc-image-id ?annotation-id ?annotation-name ?region-name)
	;;; depending on the annotation, check its exclusiveness accordingly...
	(declare ?annotation-name STRING)
	(switch ?annotation-name
		(case "One" then 
			(bind ?check-result (check-for-multiplicity ?card-id ?arc-image-id ?annotation-id ?annotation-name ?region-name))
		)
		(case "Many" then
			(bind ?check-result (check-for-multiplicity ?card-id ?arc-image-id ?annotation-id ?annotation-name ?region-name))
		)
		(case "Protected" then
			(bind ?check-result (check-for-export ?card-id ?arc-image-id ?annotation-id ?annotation-name ?region-name))
		)
		(case "Private" then
			(bind ?check-result (check-for-export ?card-id ?arc-image-id ?annotation-id ?annotation-name ?region-name))
		)
		(case "Implementation" then
			(bind ?check-result (check-for-export ?card-id ?arc-image-id ?annotation-id ?annotation-name ?region-name))
		)
		(case "By value" then
			(bind ?check-result (check-for-vr ?card-id ?arc-image-id ?annotation-id ?annotation-name ?region-name))
		)
		(case "By reference" then
			(bind ?check-result (check-for-vr ?card-id ?arc-image-id ?annotation-id ?annotation-name ?region-name))
		)
		(case "Using" then
			(bind ?check-result (check-for-hu ?card-id ?arc-image-id ?annotation-id ?annotation-name ?region-name))
		)
		(case "Has" then
			(bind ?check-result (check-for-hu ?card-id ?arc-image-id ?annotation-id ?annotation-name ?region-name))
		)
		(case "F for Friend" then
			(bind ?check-result (check-for-properties ?card-id ?arc-image-id ?annotation-id ?annotation-name ?region-name))
		)
		(case "S for Static" then
			(bind ?check-result (check-for-properties ?card-id ?arc-image-id ?annotation-id ?annotation-name ?region-name))
		)

	)       
	;;; display warning message on the status line...
	(if (neq ?check-result 1) then
		(card-set-status-text ?card-id "Cannot add the selected annotation at this position")
	)
	(return ?check-result)
)

(deffunction validate-link (?card-id ?arc-image-id ?annotation-id ?annotation-name ?region-name)
	(declare ?annotation-id INTEGER)
	(declare ?annotation-name STRING)
	(declare ?region-name STRING)
	(bind ?exclusive 6 )
	(bind ?this-annotation-id (check-for-exclusive-arc ?exclusive ?card-id ?arc-image-id ?annotation-id ?annotation-name ?region-name))
	;;; delete any existing one if there exsits a conflict element ...
	(if (> ?this-annotation-id 1) then
		(diagram-image-delete-annotation ?card-id ?arc-image-id ?this-annotation-id)
	)
	(return 1)
)


(deffunction validate-inherit (?card-id ?arc-image-id ?annotation-id ?annotation-name ?region-name)
	(declare ?annotation-id INTEGER)
	(declare ?region-name STRING)
	(if (eq ?annotation-name "Virtual") then
		(return 1)
	)
	(bind ?exclusive 3)
	(bind ?this-annotation-id (check-for-exclusive-arc ?exclusive ?card-id ?arc-image-id ?annotation-id ?annotation-name ""))
	;;; delete any existing one if there exsits a conflict element ...
	(if (> ?this-annotation-id 1) then
		(diagram-image-delete-annotation ?card-id ?arc-image-id ?this-annotation-id)
	)
	(return 1)
)       


(deffunction check-arc-annotation (?card-id ?arc-image-id ?annotation-id ?annotation-name ?region-name)
	;;; check the types of the arc and do things accordingly ...
	(bind ?arc-id (diagram-image-get-object ?card-id ?arc-image-id))
	(bind ?arc-type (diagram-object-get-string-attribute ?card-id ?arc-id "type"))
	(switch ?arc-type
		(case "Association" then
			(bind ?res (validate-association ?card-id ?arc-image-id ?annotation-id ?annotation-name ?region-name))
		)
		(case "Link" then
			(bind ?res (validate-link ?card-id ?arc-image-id ?annotation-id ?annotation-name ?region-name))
		)
		(case "Inheritance" then
			(bind ?res (validate-inherit ?card-id ?arc-image-id ?annotation-id ?annotation-name ?region-name))
		)
	)
	(return ?res)
)

