; ===========================================================================
; File:		windows.clp
; Author:	Jussi Stader
; Content:	windowing functions 
; Date:		06/12/94
; Connections:	none
; Update: 
;
; ===========================================================================

;;;----------------------------------------------------------------------------
;;; Things in this file:
;;;----------------------------------------------------------------------------
;;; (defglobal ?*boxes*)
;;; (defglobal ?*frame*)
;;; (make-checkboxes-window ?card ?message ?checks ?settings
;;; (check-boxes-get-value ?button-id)
;;; (cancel ?id)
;;; (no-selection-message ?card)
;;;----------------------------------------------------------------------------


;;; (defglobal ?*boxes*)
;;; (defglobal ?*frame*)
(defglobal ?*boxes* = (create$))
(defglobal ?*frame* = "")


;;; (make-checkboxes-window ?card ?message ?checks ?settings 
;;;		?ok-callback ?cancel-callback)
;;; Return: frame id
;; make a window with a label, checkboxes and two buttons (OK and CANCEL)
;; the checkbox labels and values are given in two multifields
;; the ok and cancel functions are passed
(deffunction make-checkboxes-window 
	    (?card ?message ?checks ?settings ?ok-callback ?cancel-callback)
  (bind ?length (length$ ?checks))
  (bind ?*frame* (frame-create (card-get-frame ?card) "" 200 200 
	200 (+ 100 (* ?length 50))))
  (bind ?panel (panel-create ?*frame*))
  (message-create ?panel ?message 10 10)
  (bind ?*boxes* (create$))
  (bind ?count 1)
  (while (<= ?count ?length) do
    (bind ?box (check-box-create ?panel "" (nth$ ?count ?checks)
			10 (* ?count 50)))
    (check-box-set-value ?box (nth$ ?count ?settings))
    (bind ?*boxes* (append ?*boxes* ?box))
    (bind ?count (+ 1 ?count)))
  (button-create ?panel ?ok-callback "OK" 10 (* ?count 50))
  (button-create ?panel ?cancel-callback "CANCEL"  50 (* ?count 50))
  (return ?*frame*)
)

;;; (check-boxes-get-value ?button-id)
;;; Return: multifield
(deffunction check-boxes-get-value (?button-id)
  (bind ?checks (create$))
  (bind ?count 1)
  (while (<= ?count (length$ ?*boxes*)) do
    (bind ?checks (append ?checks 
			  (check-box-get-value (nth$ ?count ?*boxes*))))
    (bind ?count (+ 1 ?count)))
  (return ?checks)
)

;;; (cancel ?id)
;;; Return: not to be used
(deffunction cancel (?id)
  (window-show ?*frame* 0)
)


;;; (no-selection-message ?card)
;;; Return: not to be used
(deffunction no-selection-message (?card)
     (message-box "There is nothing appropriate selected.
Plese select and try again" OK 0 (card-get-frame ?card))
)

