
;; Determine if a character is alphanumeric

(deffunction alphap (?card-id ?line ?char)
  (bind ?text (hypertext-get-span-text ?card-id ?line ?char ?line ?char))
  (if (neq (member ?text (mv-append "a" "b" "c" "d" "e" "f" "g" "h" "i" "j"
"k" "l" "m" "n" "o" "p" "q" "r" "s" "t" "u" "v" "w" "x" "y" "z" "A" "B" "C"
"D" "E" "F" "G" "H" "I" "J" "K" "L" "M" "N" "O" "P" "Q" "R" "S" "T" "U" "V"
"W" "X" "Y" "Z" "0" "1" "2" "3" "4" "5" "6" "7" "8" "9")) FALSE) 
   then (return TRUE)
   else (return FALSE)
  )
)


;; Given a line & character position, find the whole word (minus punctuation)
;; which that character lies in

(deffunction get-word (?card-id ?line ?char)
   ;; find end of string
    (hypertext-string-search ?card-id " " ?line ?char)
    (if (neq (hypertext-get-current-line ?card-id) ?line) ;; gone over a line
                                                          ;; break
     then (bind ?end-char (hypertext-get-line-length ?card-id ?line))
     else (bind ?end-char (hypertext-get-current-char ?card-id))
    )
   (while (eq (alphap ?card-id ?line ?end-char) FALSE) ;; remove punctuation chars
     (bind ?end-char (- ?end-char 1))
   )
   ;; find beginning of string
   (bind ?search-char ?char)  ;; point to search from
   (while (and (eq (alphap ?card-id ?line ?search-char) TRUE) 
              (>= ?search-char 0)) do
     (bind ?search-char (- ?search-char 1))
    )
   (bind ?begin-char (+ ?search-char 1))
   (return (mv-append ?line ?begin-char ?line ?end-char))
)


(deffunction get-words (?card-id ?line1 ?char1 ?line2 ?char2)
  (if (or (> ?line2 ?line1) 
          (and (eq ?line1 ?line2) (> ?char2 ?char1))
      )
   then (bind ?begin-char (nth 2 (get-word ?card-id ?line1 ?char1)))
        (bind ?end-char (nth 4 (get-word ?card-id ?line2 ?char2)))
        (return (mv-append ?line1 ?begin-char ?line2 ?end-char))
   else (bind ?begin-char (nth 2 (get-word ?card-id ?line2 ?char2)))
        (bind ?end-char (nth 4 (get-word ?card-id ?line1 ?char1)))
        (return (mv-append ?line2 ?begin-char ?line1 ?end-char))
 )
)

(deffunction link-block-to-node (?card-id ?block ?node-card ?node)
  (bind ?node-image (get-first-object-image ?node-card ?node))
  (bind ?node-item (get-image-item ?node-card ?node-image))
  (bind ?block-item (get-block-item ?card-id ?block))
  (link-items ?card-id ?block-item ?node-card ?node-item)
)
